% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggstacy.R
\name{ggstacy}
\alias{ggstacy}
\alias{dggstacy}
\alias{pggstacy}
\alias{qggstacy}
\alias{rggstacy}
\title{The Generalized Gamma Distribution (Stacy's original parametrization)}
\usage{
dggstacy(x, alpha, gamma, kappa, log = FALSE)

pggstacy(q, alpha, gamma, kappa, log.p = FALSE, lower.tail = TRUE)

qggstacy(
  p,
  alpha = 1,
  gamma = 1,
  kappa = 1,
  log.p = FALSE,
  lower.tail = TRUE,
  ...
)

rggstacy(n, alpha = 1, gamma = 1, kappa = 1, ...)
}
\arguments{
\item{x}{vector of (non-negative integer) quantiles.}

\item{alpha}{shape parameter of the  distribution (alpha > 0).}

\item{gamma}{scale parameter of the  distribution (gamma > 0).}

\item{kappa}{shape parameter of the  distribution (kappa > 0).}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{q}{vector of quantiles.}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}; otherwise, \eqn{P[X > x]}.}

\item{p}{vector of probabilities.}

\item{...}{further arguments passed to other methods.}

\item{n}{number of random values to return.}
}
\value{
dggstacy gives the (log) probability function, pggstacy gives the (log) distribution function, qggstacy gives the quantile function, and rggstacy generates random deviates.
}
\description{
Probability function, distribution function, quantile function and random generation for the  distribution with parameters alpha, gamma and kappa.
}
\details{
Probability density function:
\deqn{
f(x|\alpha, \gamma, \kappa) = \frac{\kappa}{\gamma^{\alpha}\Gamma(\alpha/\kappa)}x^{\alpha-1}\exp\left\{-\left(\frac{x}{\gamma}\right)^{\kappa}\right\}I_{[0, \infty)}(x),
}
for \eqn{\alpha>0}, \eqn{\gamma>0} and \eqn{\kappa>0}.

Distribution function:
\deqn{
F(t|\alpha, \gamma, \kappa) = F_{G}(x|\nu, 1),
}
where \eqn{x = \displaystyle\left(\frac{t}{\gamma}\right)^\kappa}, and \eqn{F_{G}(\cdot|\nu, 1)} corresponds to the distribution function of a gamma distribution with shape parameter \eqn{\nu = \alpha/\gamma} and scale parameter equals to 1.
}
\concept{Continuous}
\concept{Univariate}
\keyword{distribution}
