% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_ceteris_paribus.R
\name{plot.surv_ceteris_paribus_explainer}
\alias{plot.surv_ceteris_paribus_explainer}
\title{Plot for ceteris_paribus object}
\usage{
\method{plot}{surv_ceteris_paribus_explainer}(
  x,
  ...,
  selected_variable = NULL,
  scale_type = "factor",
  scale_col = NULL,
  ncol = 1
)
}
\arguments{
\item{x}{object of class "surv_ceteris_paribus_explainer"}

\item{...}{arguments to be passed to methods, such as graphical parameters for function \code{\link[ggplot2]{geom_step}}.}

\item{selected_variable}{name of variable we want to draw ceteris paribus plot}

\item{scale_type}{type of scale of colors, either "discrete" or "gradient"}

\item{scale_col}{vector containing values of low and high ends of the gradient, when "gradient" type of scale was chosen}

\item{ncol}{number of columns for faceting}
}
\description{
Function plot for ceteris_paribus object visualise estimated survival curve of mean probabilities in chosen time points. Black lines on each plot correspond to survival curve for our new observation specified in the \code{ceteris_paribus} function.
}
\examples{
\donttest{
library(survxai)
library(rms)
data("pbcTest")
data("pbcTrain")
predict_times <- function(model, data, times){
                  prob <- rms::survest(model, data, times = times)$surv
                  return(prob)
                  }
cph_model <- cph(Surv(years, status)~sex + bili + stage, data=pbcTrain, surv=TRUE, x = TRUE, y=TRUE)
surve_cph <- explain(model = cph_model, data = pbcTest[,-c(1,5)],
             y = Surv(pbcTest$years, pbcTest$status), predict_function = predict_times)
cp_cph <- ceteris_paribus(surve_cph, pbcTest[1,-c(1,5)])
plot(cp_cph)
}
}
