% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/svinecop.R
\name{svinecop_dist}
\alias{svinecop_dist}
\title{Custom S-vine models}
\usage{
svinecop_dist(
  pair_copulas,
  cs_structure,
  p,
  out_vertices,
  in_vertices,
  var_types = rep("c", dim(cs_structure)[1])
)
}
\arguments{
\item{pair_copulas}{A nested list of 'bicop_dist' objects, where
\code{pair_copulas[[t]][[e]]} corresponds to the pair-copula at edge \code{e} in tree
\code{t}. Only the most-left unique pair copulas are used, others can be omitted.}

\item{cs_structure}{The cross-sectional structure. Either a matrix, or an
\code{rvine_structure} object; see \code{rvinecopulib::rvine_structure()}}

\item{p}{the Markov order.}

\item{out_vertices}{the out-vertex; if \code{NA}, the out-vertex is selected
automatically if no structure is provided, and is equivalent to 1 if a
structure is provided.}

\item{in_vertices}{the in-vertex; if \code{NA}, the in-vertex is selected
automatically if no structure is provided, and is equivalent to 1 if a
structure is provided.}

\item{var_types}{variable types; discrete variables not (yet) allowed.}
}
\value{
Returns the model as an object with classes
\code{svinecop_dist}. Also inherits from \code{vinecop_dist}
such that many functions from \link{rvinecopulib} can be called.
}
\description{
Custom S-vine models
}
\examples{
cs_struct <- cvine_structure(1:2)
pcs <- list(
  list(  # first tree
    bicop_dist("clayton", 0, 3), # cross sectional copula
    bicop_dist("gaussian", 0, -0.1)  # serial copula
  ),
  list(  # second tree
    bicop_dist("gaussian", 0, 0.2), bicop_dist("indep")  
  ),
  list( # third tree
    bicop_dist("indep")
  )
)

cop <- svinecop_dist(
  pcs, cs_struct, p = 1, out_vertices = 1:2, in_vertices = 1:2)
}
\seealso{
\link{svinecop_loglik}, \link{svinecop_sim}, \link{svinecop_hessian},
\link{svinecop_scores}
}
