% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lou_vax_data.R
\docType{data}
\name{lou_vax_survey_control_totals}
\alias{lou_vax_survey_control_totals}
\title{Control totals for the Louisville Vaccination Survey}
\format{
A nested list object with two lists, \code{poststratification} and \code{raking},
each of which contains two elements: \code{estimates} and \code{variance-covariance}.
\describe{
  \item{poststratification}{Control totals for the combination of
  \code{RACE_ETHNICITY}, \code{SEX}, and \code{EDUC_ATTAINMENT}.
    \itemize{
    \item{estimates}{: A numeric vector of estimated population totals.}
    \item{variance-covariance}{: A variance-covariance matrix for the estimated population totals.}
    }
  }
  \item{raking}{Separate control totals for each of
  \code{RACE_ETHNICITY}, \code{SEX}, and \code{EDUC_ATTAINMENT}.
    \itemize{
    \item{estimates}{: A numeric vector of estimated population totals.}
    \item{variance-covariance}{: A variance-covariance matrix for the estimated population totals.}
    }
  }
}
}
\usage{
data(lou_vax_survey_control_totals)
}
\description{
Control totals to use for raking or post-stratification
for the Louisville Vaccination Survey data. Control totals are population size estimates
from the ACS 2015-2019 5-year Public Use Microdata Sample (PUMS)
for specific demographic categories among adults in Jefferson County, KY. \cr

These data were created using simulation.
}
\keyword{datasets}
