\name{svyPVttest}
\alias{svyPVttest}
%\alias{summary.svyPVglm}

\title{
Computation of a t-test for data from a complex survey design with usage of plausible values
}
\description{
Computes a one-sample or two-sample t-test for data from a complex survey design with usage of plausible values.  
}
\usage{
svyPVttest(formula, design, placeholder = 1:10)
}


\arguments{
  \item{formula}{Formula, outcome~group for two-sample, outcome~0 or outcome~1 for one-sample (all variables have to be part of a survey design objecct created by the survey package). For a notation description for the plausible values see in 'details'.

}
  \item{design}{a survey design which was generated by the \code{survey} package.
}
  \item{placeholder}{a vector of symbols, which were used for numbering the plausible values. For a detailed description see in 'details'.
}

}

\details{All variables mentioned in the formula object must be part of the survey design object.  Instead of the symbols, which were used for numbering the plausible values use '..' as notation (e.g. placeholder = 1:5 and PVLIT.. stands for PVLIT1, PVLIT2, PVLIT3, PVLIT4, PVLIT5). Missing values are deleted listwise.
}

\value{The function returns a list, which includes the following three dataframes. 

\item{DESC}{Shows mean and SE for each group.}
\item{TEST}{Shows the test statistic (t.value, degf and Pr.t).}
\item{N}{Shows the unweighted number of cases and the sum of weights (NA's excluded) within each group.}
}


\references{Lumley, T. (2010). \emph{Complex Surveys}. Hoboken, NJ: Wiley.

Saerndal, C.-E. & Swensson, B. & Wretman, J. (1992). \emph{Model Assisted Survey Sampling}. New York: Springer.

Chaudhuri, A. & Stenger, H. (2005). \emph{Survey Sampling. Theory and Methods}. Boka Raton, FL: Chapman & Hall/CRC.
.
}
\author{
Jakob Peterbauer
}



\seealso{
\code{\link{svyttest}, \link{svyPVpm}, \link{svyPVglm}}}
\examples{
data(svy_example1)
res <- svyPVttest(plaus.. ~ sex, svy.exrep, placeholder = 1:3)

res
}
% Add one or more standard keywords, see file 'KEYWORDS' in the
% R documentation directory.
\keyword{ttest}
