% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidiers_nnetar.R
\name{tidiers_nnetar}
\alias{tidiers_nnetar}
\alias{sw_tidy.nnetar}
\alias{sw_glance.nnetar}
\alias{sw_augment.nnetar}
\title{Tidying methods for Nural Network Time Series models}
\usage{
\method{sw_tidy}{nnetar}(x, ...)

\method{sw_glance}{nnetar}(x, ...)

\method{sw_augment}{nnetar}(x, data = NULL, timetk_idx = FALSE,
  rename_index = "index", ...)
}
\arguments{
\item{x}{An object of class "nnetar"}

\item{...}{Additional parameters (not used)}

\item{data}{Used with \code{sw_augment} only.
\code{NULL} by default which simply returns augmented columns only.
User can supply the original data, which returns the data + augmented columns.}

\item{timetk_idx}{Used with \code{sw_augment} only.
Uses a irregular timetk index if present.}

\item{rename_index}{Used with \code{sw_augment} only.
A string representing the name of the index generated.}
}
\value{
\strong{\code{sw_tidy()}} returns one row for each model parameter,
with two columns:
\itemize{
\item \code{term}: The smoothing parameters (alpha, gamma) and the initial states
(l, s0 through s10)
\item \code{estimate}: The estimated parameter value
}

\strong{\code{sw_glance()}} returns one row with the columns
\itemize{
\item \code{model.desc}: A description of the model including the
three integer components (p, d, q) are the AR order,
the degree of differencing, and the MA order.
\item \code{sigma}: The square root of the estimated residual variance
\item \code{logLik}: The data's log-likelihood under the model (\code{NA})
\item \code{AIC}: The Akaike Information Criterion (\code{NA})
\item \code{BIC}: The Bayesian Information Criterion (\code{NA})
\item \code{ME}: Mean error
\item \code{RMSE}: Root mean squared error
\item \code{MAE}: Mean absolute error
\item \code{MPE}: Mean percentage error
\item \code{MAPE}: Mean absolute percentage error
\item \code{MASE}: Mean absolute scaled error
\item \code{ACF1}: Autocorrelation of errors at lag 1
}

\strong{\code{sw_augment()}} returns a tibble with the following time series attributes:
\itemize{
\item \code{index}: An index is either attempted to be extracted from the model or
a sequential index is created for plotting purposes
\item \code{.actual}: The original time series
\item \code{.fitted}: The fitted values from the model
\item \code{.resid}: The residual values from the model
}
}
\description{
These methods tidy the coefficients of NNETAR models of univariate time
series.
}
\examples{
library(dplyr)
library(forecast)
library(sweep)

fit_nnetar <- lynx \%>\%
    nnetar()

sw_tidy(fit_nnetar)
sw_glance(fit_nnetar)
sw_augment(fit_nnetar)

}
\seealso{
\code{\link[=nnetar]{nnetar()}}
}
