% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pack.R
\name{unpack_course}
\alias{unpack_course}
\title{Unpack an \code{.swc} file into a swirl course}
\usage{
unpack_course(file_path = file.choose(), export_path = dirname(file_path))
}
\arguments{
\item{file_path}{Optional, full path to the \code{.swc} file you wish to unpack.
If not specified, you will be prompted to choose a file interactively.}

\item{export_path}{Optional, full path to the directory where the swirl course
should be exported. If not specified, the course will appear in the same
directory as the \code{.swc} file.}
}
\value{
A string, the path to the unpacked course directory, invisibly.
}
\description{
Invisibly returns the path to the unpacked course directory.
}
\examples{
\dontrun{
# Unpack a course and interactively choose a .swc file
unpack_course()

# Unpack a course where the .swc file is explicitly specified
unpack_course(file.path("~", "Desktop", "R_Programming.swc"))

# Unpack a course and specify where the .swc file is located and where the
# course should be exported.
unpack_course(file.path("~", "Desktop", "R_Programming.swc"),
 file.path("~", "Developer", "swirl"))
}
}
