% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_swmm.R
\name{run_swmm}
\alias{run_swmm}
\title{Initiate a simulation run}
\usage{
run_swmm(inp, rpt = NULL, out = NULL, exec = NULL, stdout = "",
  wait = TRUE)
}
\arguments{
\item{inp}{Name and path to an input file.}

\item{rpt}{Name and path to a report file.}

\item{out}{Name and path to an out file.}

\item{exec}{Name and path to swmm5 executable. If not manually set,
the following paths are looked up when package gets loaded:
windows: "C:/Program Files (x86)/EPA SWMM 5.X.XXX/swmm5.exe"
not windows: "/usr/local/bin/swmm5" , "/usr/bin/swmm5"}

\item{stdout}{where output to \file{stdout} or
    \file{stderr} should be sent.  Possible values are \code{""}, to the \R
    console (the default), \code{NULL} or \code{FALSE} (discard output),
    \code{TRUE} (capture the output in a character vector) or a
    character string naming a file.}

\item{wait}{a logical (not \code{NA}) indicating whether the \R
    interpreter should wait for the command to finish, or run it
    asynchronously.  This will be ignored (and the interpreter will
    always wait) if \code{stdout = TRUE} or \code{stderr = TRUE}.}
}
\description{
This function runs a swmm inp file. If rpt and out files are not
specified files are automatically created in the same directory of
the inp file.
}
\details{
The path to a swmm5 executable is read by calling 'getOption("swmmr.exec")'.
}
\examples{
 
\dontrun{
result <- run_swmm("model.inp")
}
}
