% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tally_poly_vector_by.R
\name{tally_poly_vector_by}
\alias{tally_poly_vector_by}
\title{Vector Tally of Poly-Syllabic Words By Grouping Variable(s)}
\usage{
tally_poly_vector_by(x, group, as.tibble = tibble_output(), ...)
}
\arguments{
\item{x}{A character vector.}

\item{group}{The grouping variable(s).  Takes a single grouping variable or a
list of 1 or more grouping variables.}

\item{as.tibble}{logical.  If \code{TRUE} the output class will be set to a
\pkg{tibble}, otherwise a \code{\link[data.table]{data.table}}.  Default
checks \code{getOption("tibble.out")} as a logical.  If this is \code{NULL}
the default \code{\link[textshape]{tibble_output}} will set \code{as.tibble}
to \code{TRUE} if \pkg{dplyr} is loaded.  Otherwise, the output will be a
\code{\link[data.table]{data.table}}.}

\item{\ldots}{ignored.}
}
\value{
Returns a \code{\link[base]{data.frame}}
(\code{\link[data.table]{data.table}}) of integer tallies for the total number
of poly syllable words for each string in the vector.
}
\description{
Poly-syllabic (>= 3 syllables) word tallies for the words in a vector of
strings by grouping variable(s).
}
\examples{
dat <- data.frame(
   text = c("I like excellent chicken.", "I want eggs benedict now.", "Really?"),
   group = c("A", "B", "A")
)
tally_poly_vector_by(dat$text, dat$group)

with(presidential_debates_2012, tally_poly_vector_by(dialogue, person))
with(presidential_debates_2012, tally_poly_vector_by(dialogue, list(role, time)))
with(presidential_debates_2012, tally_poly_vector_by(dialogue, list(person, time)))
}
\seealso{
Other syllable.functions: \code{\link{count_string}},
  \code{\link{count_vector_by}},
  \code{\link{count_vector}}, \code{\link{sum_string}},
  \code{\link{sum_vector_by}}, \code{\link{sum_vector}},
  \code{\link{tally_both_string}},
  \code{\link{tally_both_vector_by}},
  \code{\link{tally_both_vector}},
  \code{\link{tally_di_string}},
  \code{\link{tally_di_vector_by}},
  \code{\link{tally_di_vector}},
  \code{\link{tally_mono_string}},
  \code{\link{tally_mono_vector_by}},
  \code{\link{tally_mono_vector}},
  \code{\link{tally_poly_string}},
  \code{\link{tally_poly_vector}},
  \code{\link{tally_short_string}},
  \code{\link{tally_short_vector_by}},
  \code{\link{tally_short_vector}}
}

