/*
 * Decompiled with CFR 0.152.
 */
package sample;

public class HapNodes {
    private static final double loadFactor = 0.75;
    private int[] index;
    private int[] node;
    private double[] value;
    private int size = 0;
    private int maxSize = 1024;
    private int rehashThreshold = (int)(0.75 * (double)this.maxSize);

    public HapNodes() {
        this.index = new int[this.maxSize];
        this.node = new int[this.maxSize];
        this.value = new double[this.maxSize];
    }

    private int index(int n) {
        int n2 = n;
        int n3 = 97 + n;
        if ((n3 & 1) == 0) {
            ++n3;
        }
        for (int i = 0; i < this.maxSize; ++i) {
            int n4 = (n2 + i * n3) % this.maxSize;
            if (n4 < 0) {
                n4 = -n4;
            }
            if (this.value[n4] != 0.0 && this.node[n4] != n) continue;
            return n4;
        }
        assert (false);
        return -1;
    }

    private void rehash() {
        assert (this.size >= this.rehashThreshold);
        int n = 2 * this.maxSize;
        if (n < 0) {
            throw new IllegalStateException("hash table overflow");
        }
        int[] nArray = this.index;
        int[] nArray2 = this.node;
        double[] dArray = this.value;
        this.maxSize = n;
        this.index = new int[n];
        this.node = new int[n];
        this.value = new double[n];
        for (int i = 0; i < this.size; ++i) {
            int n2;
            int n3 = nArray[i];
            this.index[i] = n2 = this.index(nArray2[n3]);
            this.node[n2] = nArray2[n3];
            this.value[n2] = dArray[n3];
        }
        this.rehashThreshold = (int)(0.75 * (double)this.maxSize);
    }

    public void maxUpdate(int n, double d) {
        if (d > 0.0) {
            int n2 = this.index(n);
            if (this.value[n2] > 0.0) {
                if (d > this.value[n2]) {
                    this.value[n2] = d;
                }
            } else {
                this.index[this.size++] = n2;
                this.node[n2] = n;
                this.value[n2] = d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public void sumUpdate(int n, double d) {
        if (d > 0.0) {
            int n2 = this.index(n);
            if (this.value[n2] > 0.0) {
                int n3 = n2;
                this.value[n3] = this.value[n3] + d;
            } else {
                this.index[this.size++] = n2;
                this.node[n2] = n;
                int n4 = n2;
                this.value[n4] = this.value[n4] + d;
                if (this.size >= this.rehashThreshold) {
                    this.rehash();
                }
            }
        } else if (!(d >= 0.0)) {
            throw new IllegalArgumentException(String.valueOf(d));
        }
    }

    public int size() {
        return this.size;
    }

    private void checkSize(int n) {
        if (n >= this.size()) {
            throw new IndexOutOfBoundsException(String.valueOf(n));
        }
    }

    public int enumNode(int n) {
        this.checkSize(n);
        return this.node[this.index[n]];
    }

    public double enumValue(int n) {
        this.checkSize(n);
        return this.value[this.index[n]];
    }

    public double value(int n) {
        return this.value[this.index(n)];
    }

    public void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.value[this.index[i]] = 0.0;
        }
        this.size = 0;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(80);
        stringBuilder.append("size=");
        stringBuilder.append(this.size);
        for (int i = 0; i < this.size; ++i) {
            stringBuilder.append(" (");
            stringBuilder.append(i);
            stringBuilder.append(": node=");
            stringBuilder.append(this.enumNode(i));
            stringBuilder.append(" value=");
            stringBuilder.append(this.enumValue(i));
            stringBuilder.append(") ");
        }
        return stringBuilder.toString();
    }
}

