/*
 * Decompiled with CFR 0.152.
 */
package vcf;

import beagleutil.Samples;
import blbutil.SampleFileIterator;
import java.io.File;
import java.util.NoSuchElementException;
import main.NuclearFamilies;
import vcf.BitSetGT;
import vcf.MedMemGL;
import vcf.MedMemGTGL;
import vcf.VcfEmission;
import vcf.VcfEmissionFactory;
import vcf.VcfRecord;

public class VcfEmissionIterator
implements SampleFileIterator<VcfEmission> {
    private final SampleFileIterator<VcfRecord> it;
    private final VcfEmissionFactory emissionFactory;

    private VcfEmissionIterator(SampleFileIterator<VcfRecord> sampleFileIterator, VcfEmissionFactory vcfEmissionFactory) {
        if (sampleFileIterator.samples().nSamples() == 0) {
            String string = "missing sample data";
            throw new IllegalArgumentException(string);
        }
        if (vcfEmissionFactory == null) {
            throw new IllegalArgumentException("emissionFactory==null");
        }
        this.it = sampleFileIterator;
        this.emissionFactory = vcfEmissionFactory;
    }

    public static SampleFileIterator<VcfEmission> gt(SampleFileIterator<VcfRecord> sampleFileIterator, File file, boolean bl) {
        NuclearFamilies nuclearFamilies = new NuclearFamilies(sampleFileIterator.samples(), file);
        VcfEmissionFactory vcfEmissionFactory = VcfEmissionIterator.gt(nuclearFamilies, bl);
        return new VcfEmissionIterator(sampleFileIterator, vcfEmissionFactory);
    }

    public static SampleFileIterator<VcfEmission> gl(SampleFileIterator<VcfRecord> sampleFileIterator, File file, float f) {
        NuclearFamilies nuclearFamilies = new NuclearFamilies(sampleFileIterator.samples(), file);
        VcfEmissionFactory vcfEmissionFactory = VcfEmissionIterator.gl(nuclearFamilies, f);
        return new VcfEmissionIterator(sampleFileIterator, vcfEmissionFactory);
    }

    public static SampleFileIterator<VcfEmission> gtgl(SampleFileIterator<VcfRecord> sampleFileIterator, File file, boolean bl, float f, boolean bl2) {
        NuclearFamilies nuclearFamilies = new NuclearFamilies(sampleFileIterator.samples(), file);
        VcfEmissionFactory vcfEmissionFactory = VcfEmissionIterator.gtgl(nuclearFamilies, bl, f, bl2);
        return new VcfEmissionIterator(sampleFileIterator, vcfEmissionFactory);
    }

    @Override
    public Samples samples() {
        return this.it.samples();
    }

    @Override
    public File file() {
        return this.it.file();
    }

    @Override
    public void close() {
        this.it.close();
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public VcfEmission next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.emissionFactory.create((VcfRecord)this.it.next());
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("VcfGtIterator.remove()");
    }

    private static VcfEmissionFactory gt(final NuclearFamilies nuclearFamilies, final boolean bl) {
        return new VcfEmissionFactory(){

            @Override
            public VcfEmission create(VcfRecord vcfRecord) {
                return new BitSetGT(vcfRecord, nuclearFamilies, bl);
            }
        };
    }

    private static VcfEmissionFactory gl(final NuclearFamilies nuclearFamilies, final float f) {
        if (Float.isNaN(f) || f <= 1.0f) {
            throw new IllegalArgumentException("maxLR: " + f);
        }
        return new VcfEmissionFactory(){

            @Override
            public VcfEmission create(VcfRecord vcfRecord) {
                return new MedMemGL(vcfRecord, nuclearFamilies, f);
            }
        };
    }

    private static VcfEmissionFactory gtgl(final NuclearFamilies nuclearFamilies, final boolean bl, final float f, final boolean bl2) {
        if (Float.isNaN(f) || f <= 1.0f) {
            throw new IllegalArgumentException("maxLR: " + f);
        }
        return new VcfEmissionFactory(){

            @Override
            public VcfEmission create(VcfRecord vcfRecord) {
                return new MedMemGTGL(vcfRecord, nuclearFamilies, bl, f, bl2);
            }
        };
    }
}

