% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/a_class-methods_helpers.R
\name{marginalize_attr}
\alias{marginalize_attr}
\title{Marginalize synthetic attributes}
\usage{
marginalize_attr(obj, varlist, marginalize_out = FALSE)
}
\arguments{
\item{obj}{An object of class \code{"micro_synthetic"}.}

\item{varlist}{A character vector of variable, or attribute, names in \code{obj}.}

\item{marginalize_out}{Logical. Do you wish to *remove* the variables in \code{varlist} 
instead of keeping them? Defaults to \code{FALSE}}
}
\description{
Marginalize, (ie- reduce in number), attributes of a synthetic dataset of class
'micro_synthetic' or a list of synthetic datasets of class 'synthACS'. This is done
by marginalizing the joint distribution based on a set of specified attributes (see Arguments below).
}
\examples{
{
# dummy data setup
set.seed(567L)
df <- data.frame(gender= factor(sample(c("male", "female"), size= 100, replace= TRUE)),
                 age= factor(sample(1:5, size= 100, replace= TRUE)),
                 pov= factor(sample(c("below poverty", "at above poverty"), 
                                   size= 100, replace= TRUE, prob= c(.15,.85))),
                 p= runif(100))
df$p <- df$p / sum(df$p)
class(df) <- c("data.frame", "micro_synthetic")

df2 <- marginalize_attr(df, varlist= "gender")
df3 <- marginalize_attr(df, varlist= c("gender", "age"))
df4 <- marginalize_attr(df, varlist= c("gender", "age"), marginalize_out= TRUE)

df_list <- replicate(10, df, simplify= FALSE)
dummy_list <- replicate(10, list(NULL), simplify= FALSE)
df_list <- mapply(function(a,b) {return(list(a, b))}, a= dummy_list, b= df_list, SIMPLIFY = FALSE)
class(df_list) <- c("list", "synthACS")

# run the function
df_list2 <- marginalize_attr(df_list, varlist= c("gender", "age"))
}
}
