% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/register_font.R
\name{register_font}
\alias{register_font}
\alias{registry_fonts}
\alias{clear_registry}
\title{Register font collections as families}
\usage{
register_font(
  name,
  plain,
  bold = plain,
  italic = plain,
  bolditalic = plain,
  features = font_feature()
)

registry_fonts()

clear_registry()
}
\arguments{
\item{name}{The name the collection will be known under (i.e. \emph{family})}

\item{plain, bold, italic, bolditalic}{Fontfiles for the different faces of the
collection. can either be a filepath or a list containing a filepath and an
index (only for font files containing multiple fonts). If not given it will
default to the \code{plain} specification.}

\item{features}{A \code{\link{font_feature}} object describing the specific OpenType
font features to turn on for the registered font.}
}
\value{
\code{register_font()} and \code{clear_registry()} returns \code{NULL} invisibly.
\code{registry_fonts()} returns a data table in the same style as \code{\link[=system_fonts]{system_fonts()}}
though less detailed and not based on information in the font file.
}
\description{
By design, systemfonts searches the fonts installed natively on the system.
It is possible, however, to register other fonts from e.g. font packages or
local font files, that will get searched before searching any installed
fonts. You can always get an overview over all registered fonts with the
\code{registry_fonts()} function that works as a registry focused analogue to
\code{\link[=system_fonts]{system_fonts()}}. If you wish to clear out the registry, you can either
restart the R session or call \code{clear_registry()}.
}
\details{
\code{register_font} also makes it possible to use system fonts with traits that
is not covered by the graphic engine in R. In plotting operations it is only
possible to specify a family name and whether or not the font should be bold
and/or italic. There are numerous fonts that will never get matched to this,
especially because bold is only one of many weights.

Apart from granting a way to use new varieties of fonts, font registration
also allows you to override the default \code{sans}, \code{serif}, and \code{mono} mappings,
simply by registering a collection to the relevant default name. As
registered fonts are searched first it will take precedence over the default.
}
\examples{
# Create a random font collection
fonts <- system_fonts()
plain <- sample(which(!fonts$italic & fonts$weight <= 'normal'), 1)
bold <- sample(which(!fonts$italic & fonts$weight > 'normal'), 1)
italic <- sample(which(fonts$italic & fonts$weight <= 'normal'), 1)
bolditalic <- sample(which(fonts$italic & fonts$weight > 'normal'), 1)
register_font(
  'random', 
  plain = list(fonts$path[plain], fonts$index[plain]), 
  bold = list(fonts$path[bold], fonts$index[bold]), 
  italic = list(fonts$path[italic], fonts$index[italic]),
  bolditalic = list(fonts$path[bolditalic], fonts$index[bolditalic])
)

# Look at your creation
registry_fonts()

# Reset
clear_registry()

}
