% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/trakt.movie.releases.R
\name{trakt.movie.releases}
\alias{trakt.movie.releases}
\title{Get a single movie's release details}
\usage{
trakt.movie.releases(target, country = NULL)
}
\arguments{
\item{target}{The \code{id} of the movie requested. Either the \code{slug}
(e.g. \code{"tron-legacy-2010"}), \code{trakt id} or \code{IMDb id}. If multiple targets are
provided, an additional \code{movie} column is appended to the \code{rbind}ed results, containing
the movie's \code{id} provided as \code{target}.}

\item{country}{Optional two letter country code.}
}
\value{
A \code{data.frame} containing movie release dates and certification.
}
\description{
\code{trakt.movie.releases} returns a single movie's release information,
including the release date, country code (two letter, e.g. \code{us}), and
the certification (e.g. \code{PG}).
}
\note{
See \href{http://docs.trakt.apiary.io/reference/movies/releases/get-all-movie-releases}{the
 trakt API docs for further info}
}
\examples{
\dontrun{
get_trakt_credentials() # Set required API data/headers
trakt.movie.releases("tron-legacy-2010")
}
}
\seealso{
Other movie data: \code{\link{trakt.movie.people}};
  \code{\link{trakt.movie.ratings}};
  \code{\link{trakt.movie.summary}};
  \code{\link{trakt.movie.watching}};
  \code{\link{trakt.movies.popular}};
  \code{\link{trakt.movies.related}};
  \code{\link{trakt.movies.trending}};
  \code{\link{trakt.stats}}
}

