% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jagsBayesianModel.R
\name{jagsBayesianModel}
\alias{jagsBayesianModel}
\title{Returns a JAGS-based Bayesian model to use within tRophicPosition.}
\usage{
jagsBayesianModel(model = NULL, ...)
}
\arguments{
\item{model}{string. Can be "oneBaseline", "twoBaselines" or
"twoBaselinesFull" at the moment.}

\item{...}{additional arguments passed to \code{\link{jagsOneBaseline}},
\code{\link{jagsTwoBaselines}} or \code{\link{jagsTwoBaselinesFull}}.}
}
\value{
a jags model as a character string
}
\description{
This function returns a string with a Bayesian model to be used with trophic
position calculations
}
\examples{
# Example with priors for TP.
# One baseline Bayesian model with prior for trophic position of consumer
# defined as a normal distribution with mean 3 and sd 1
model.string <- jagsBayesianModel(model = "oneBaseline", TP = "dnorm(3,1)")

# Two baselines model with trophic level of baseline = 1
model.string <- jagsBayesianModel(model = "twoBaselines", lambda = 1)

# Two baselines full model with priors for alpha
model.string <- jagsBayesianModel(model = "twoBaselinesFull",
alpha = "dbeta(10,1)")
}
