% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-where.R
\name{where-table.express}
\alias{where-table.express}
\alias{where}
\alias{where.ExprBuilder}
\title{Where clause}
\usage{
where(.data, ...)

\method{where}{ExprBuilder}(.data, ..., .collapse = `&`,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE))
}
\arguments{
\item{.data}{The input data.}

\item{...}{Arguments for the specific methods.}

\item{.collapse}{A boolean function which will be used to "concatenate" all conditions in \code{...}.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}
}
\description{
Clause for subsetting rows.
}
\details{
To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    start_expr \%>\%
    where(vs == 0, am == 1)

}
