% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VERBS-select.R
\name{select-table.express}
\alias{select-table.express}
\alias{select.ExprBuilder}
\alias{select.EagerExprBuilder}
\alias{select.data.table}
\title{Select clause}
\usage{
\method{select}{ExprBuilder}(
  .data,
  ...,
  .negate = FALSE,
  .parse = getOption("table.express.parse", FALSE),
  .chain = getOption("table.express.chain", TRUE)
)

\method{select}{EagerExprBuilder}(.data, ..., .parent_env = rlang::caller_env())

\method{select}{data.table}(.data, ...)
}
\arguments{
\item{.data}{An instance of \link{ExprBuilder}.}

\item{...}{Clause for selecting columns. For \code{j} inside the \code{data.table}'s frame.}

\item{.negate}{Whether to negate the selection semantics and keep only columns that do \emph{not}
match what's given in \code{...}.}

\item{.parse}{Logical. Whether to apply \code{\link[rlang:parse_expr]{rlang::parse_expr()}} to obtain the expressions.}

\item{.chain}{Logical. Should a new frame be automatically chained to the expression if the
clause being set already exists?}

\item{.parent_env}{See \code{\link[=end_expr]{end_expr()}}}
}
\description{
Select columns of a \link[data.table:data.table-class]{data.table::data.table}.
}
\details{
The expressions in \code{...} support \link[tidyselect:language]{tidyselect::select_helpers}.

To see more examples, check the
\href{https://asardaes.github.io/table.express/articles/table.express.html}{vignette}, or the
\link{table.express-package} entry.
}
\examples{

data("mtcars")

data.table::as.data.table(mtcars) \%>\%
    select(mpg:cyl)

}
