% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_value.R
\name{table_value}
\alias{table_value}
\title{General rounding for tables}
\usage{
table_value(x, rspec = NULL)
}
\arguments{
\item{x}{a vector of numeric values.}

\item{rspec}{a \code{rounding_specification} object. If no \code{rspec}
is given, a default setting will round values to decimal places
based on the magnitude of the values.}
}
\value{
a vector of character values (rounded numbers).
}
\description{
\code{table_value()} casts numeric vectors into character vectors.
The main purpose of \code{table_value()} is to round and format
numeric data for presentation.
}
\examples{

table_value(0.123)
table_value(1.23)
table_value(12.3)

with(mtcars, table_value(disp))

}
\seealso{
Other table helpers: 
\code{\link{table_ester}()},
\code{\link{table_glue}()},
\code{\link{table_pvalue}()}
}
\concept{table helpers}
