% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_inline.R
\name{as_inline}
\alias{as_inline}
\title{Convert table data to inline list}
\usage{
as_inline(data, tbl_variables, tbl_values)
}
\arguments{
\item{data}{a data frame.}

\item{tbl_variables}{column names that will be used to form groups in the table}

\item{tbl_values}{column names that contains table values.}
}
\value{
a list of \code{tbl_values} values for each permutation of \code{tbl_variables}
}
\description{
Convert table data to inline list
}
\note{
variables in \code{tbl_variables} that have missing values will be
have their missing values converted into an explicit category named
variable_missing, where 'variable' is the name of the variable.
}
\examples{

example_data <- data.frame(
  sex = c("female", "male"),
  height = c("158 (154 - 161)", "178 (175 - 188)")
)

as_inline(example_data, tbl_variables = 'sex', tbl_values = 'height')

car_data <- mtcars
car_data$car_name <- rownames(mtcars)
as_inline(car_data, tbl_variables = 'car_name', tbl_values = 'mpg')

}
