% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_css_conditional_format.R
\name{make_css_color_rank_theme}
\alias{make_css_color_rank_theme}
\title{Get css properties for custom color rank theme}
\usage{
make_css_color_rank_theme(
  column_data,
  colors,
  css_property = "background-color",
  decreasing = FALSE,
  same_scale = TRUE
)
}
\arguments{
\item{column_data}{A named list of vectors of values that are in a tableHTML column which
should be mapped to a color palette.}

\item{colors}{colors to interpolate; must be a valid argument to
    \code{\link[grDevices]{col2rgb}()}.}

\item{css_property}{Character. An optional character specifying the css attribute
that should be used. Default is \code{'backgroud-color'}}

\item{decreasing}{logical.  Should the sort order be increasing or
    decreasing? For the \code{"radix"} method, this can be a vector of
    length equal to the number of arguments in \code{\dots}. For the
    other methods, it must be length one.}

\item{same_scale}{Logical. This flag indicates whether the condition should be applied to columns individually or
in conjunction. If TRUE, the condition will be evaluated on all values of all \code{columns}. If FALSE,
the condition will be evaluated per column.}
}
\value{
A list of css properties
}
\description{
\code{make_css_color_rank_theme} will create a list of css properties needed for custom conditional formatting.
}
\details{
\code{make_css_color_rank_theme} will add conditional css to a tableHTML's columns. \code{add_conditional_css_column} will only
  add css to the columns without the headers or second headers (i.e. it only affects the td tag
  internally and not the th tag). If you want to add css to the headers or second headers please
  use \code{add_css_header} or \code{add_css_second_header}.
}
\examples{

tableHTML <- tableHTML(mtcars)

css <- make_css_color_rank_theme(list(mpg = mtcars$mpg),
                                 c("orange", "yellow","springgreen","royalblue"))

tableHTML \%>\% add_css_conditional_column(conditional = "color_rank",
                                        color_rank_theme = "Custom",
                                        color_rank_css = css, column = 1)

}
