% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/notes.R
\name{note-helpers}
\alias{note-helpers}
\alias{note_is_natural}
\alias{note_is_accidental}
\alias{note_is_flat}
\alias{note_is_sharp}
\alias{naturalize}
\alias{sharpen_flat}
\alias{flatten_sharp}
\alias{note_set_key}
\alias{note_rotate}
\alias{note_shift}
\alias{note_arpeggiate}
\alias{pretty_notes}
\title{Note and pitch helpers}
\usage{
note_is_natural(notes)

note_is_accidental(notes)

note_is_flat(notes)

note_is_sharp(notes)

naturalize(notes, type = c("both", "flat", "sharp"),
  ignore_octave = FALSE)

sharpen_flat(notes, ignore_octave = FALSE)

flatten_sharp(notes, ignore_octave = FALSE)

note_set_key(notes, key = "c")

note_rotate(notes, n = 0)

note_shift(notes, n = 0)

note_arpeggiate(notes, n = 0, ...)

pretty_notes(notes, ignore_octave = TRUE)
}
\arguments{
\item{notes}{character, a noteworthy string, space-delimited or vector of individual entries.}

\item{type}{character, type of note to naturalize.}

\item{ignore_octave}{logical, strip any octave notation that may be present, returning only the basic notes without explicit pitch.}

\item{key}{character, key signature to coerce any accidentals to the appropriate form for the key. May also specify \code{"sharp"} or \code{"flat"}.}

\item{n}{integer, degree of rotation.}

\item{...}{additional arguments to \code{transpose}, specifically \code{key} and \code{style}.}
}
\value{
character
}
\description{
Helper functions for manipulating individual note and pitch strings.
}
\details{
In this context, sharpening flats and flattening sharps refers to inverting their notation, not raising and lowering a flatted or sharped note by one semitone.
For the latter, use \code{naturalize}, which removes flat and/or sharp notation from a string.

Due to its simplicity, for \code{note_rotate} the strings may include chords. It simply rotates anything space-delimited or vectorized in place.
Octave numbering is ignored if present.

By contrast, for \code{note_shift} the entire sequence is shifted up or down, as if inverting a broken chord.
In this case \code{notes} is strictly interpreted and may not include chords.
Octave numbering applies, though large, multi-octave gaps will be condensed in the process.
Given the context of \code{note_shift}, the \code{notes} sequence should be ordered by increasing pitch.
If it is not, ordering will be forced with each inversion during the \code{n} shifts.

\code{note_arpeggiate} also allows notes only. It is similar to \code{note_shift}, except that instead of a moving window,
it grows from the original set of notes by \code{n} in the direction of the sign of \code{n}.
}
\examples{
x <- "a_ a a#"
note_is_natural(x)
note_is_accidental(x)
note_is_flat(x)
note_is_sharp(x)
note_set_key(x, "f")
note_set_key(x, "g")

x <- "e_2 a_, c#f#a#"
naturalize(x)
naturalize(x, "sharp")
sharpen_flat(x)
flatten_sharp(x)
pretty_notes(x)

note_rotate(x, 1)
note_shift("c e g", 1)
note_shift("c e g", -4)
note_arpeggiate("c e g", 5)
note_arpeggiate("c e g", -5)
}
