% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab.R
\name{tab}
\alias{tab}
\title{Create tablature}
\usage{
tab(score, file, key = "c", time = "4/4", tempo = "2 = 60",
  header = NULL, string_names = NULL, paper = NULL, endbar = TRUE,
  midi = TRUE, keep_ly = FALSE, path = NULL, details = TRUE)
}
\arguments{
\item{score}{a score object.}

\item{file}{character, output file ending in .pdf or .png. May include an absolute or relative path.}

\item{key}{character, key signature, e.g., \code{c}, \code{b_}, \code{f#m}, etc.}

\item{time}{character, defaults to \code{"4/4"}.}

\item{tempo}{character, defaults to \code{"2 = 60"}.}

\item{header}{a named list of arguments passed to the header of the LilyPond file. See details.}

\item{string_names}{label strings at beginning of tab staff. \code{NULL} (default) for non-standard tunings only, \code{TRUE} or \code{FALSE} for force on or off completely.}

\item{paper}{a named list of arguments for the LilyPond file page layout. See details.}

\item{endbar}{character, the end bar.}

\item{midi}{logical, output midi file in addition to tablature.}

\item{keep_ly}{logical, keep LilyPond file.}

\item{path}{character, optional output directory prefixed to \code{file}, may be an absolute or relative path. If \code{NULL} (default), only \code{file} is used.}

\item{details}{logical, set to \code{FALSE} to disable printing of log output to console.}
}
\value{
nothing returned; a file is written.
}
\description{
Create sheet music/guitar tablature from a music score.
}
\details{
Generate a pdf or png of a music score using the LilyPond music engraving program.
Output format is inferred from \code{file} extension. This function is a wrapper around \code{\link{lilypond}}, the function that creates the LilyPond (\code{.ly}) file.

For Windows users, add the path to the LilyPond executable to the system path variable. For example, if the file is at \code{C:/Program Files (x86)/LilyPond/usr/bin/lilypond.exe},
then add \code{C:/Program Files (x86)/LilyPond/usr/bin} to the system path.
}
\examples{
if(tabr_options()$lilypond != ""){
  x <- phrase("c ec'g' ec'g'", "4 4 2", "5 432 432")
  x <- track(x)
  x <- score(x)
  outfile <- file.path(tempdir(), "out.pdf")
  tab(x, outfile, details = FALSE) # requires LilyPond installation
}
}
\seealso{
\code{\link{lilypond}}, \code{\link{miditab}}
}
