% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lyrics.R
\name{lyrics}
\alias{lyrics}
\alias{lyrical}
\alias{as_lyrics}
\alias{is_lyrics}
\alias{lyrics_template}
\title{Create lyrics and check lyrics string validity}
\usage{
lyrical(x)

as_lyrics(x, format = NULL)

is_lyrics(x)

lyrics_template(x, format = NULL)
}
\arguments{
\item{x}{character or lyrics object. For \code{lyrics_template}, an integer
or one of the classes \code{noteworthy}, \code{noteinfo} or \code{music} to
derive the number of timesteps from.}

\item{format}{\code{NULL} or character, the timestep delimiter format,
\code{"space"} or \code{"vector"}.}
}
\value{
depends on the function
}
\description{
Functions for creating and checking lyrics objects.
}
\details{
The \code{lyrics} class is a simple class for arranging lyrics text by
timestep. Its structure and behavior aligns with that of the classes
\code{noteworthy}, \code{noteinfo} and \code{music}.

\code{lyrical} is a trivial function that returns a scalar logical result
essentially for any object that inherits from character, though this check
may become more specific in the future.

\code{as_lyrics} can be used to coerce to the \code{lyrics} class.
Coercion will fail if the string is not lyrical.
The \code{lyrics} class has its own \code{print} and \code{summary} methods.

When \code{format = NULL}, the timestep delimiter format is inferred from
the lyrical string input.
}
\examples{
# space-delimited lyrics; use periods for timesteps with no lyric
x <- "These are the ly- rics . . . to this song"
is_lyrics(x)
lyrical(x)
as_lyrics(x)

# character vector; empty, period or NA for no lyric
x <- c("These", "are", "the", "ly-", "rics",
       "", ".", NA, "to", "this", "song") #
as_lyrics(x)

# generate empty lyrics object from noteworthy, noteinfo or music object
notes <- as_noteworthy("c d e d c r*3 e g c'")
x <- lyrics_template(notes)
x

x[1:5] <- strsplit("These are the ly- rics", " ")[[1]]
x[9:11] <- c("to", "this", "song")
x

summary(x)

attributes(x)
}
