% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/test.R
\name{test}
\alias{test}
\alias{test_diversity}
\alias{test_diversity-method}
\alias{test_fit}
\alias{test_fit-method}
\alias{test_fit,CountMatrix-method}
\alias{test_diversity,CountMatrix-method}
\title{Tests on Abundance Data}
\usage{
test_diversity(object, ...)

test_fit(object, ...)

\S4method{test_fit}{CountMatrix}(object, simplify = FALSE, ...)

\S4method{test_diversity}{CountMatrix}(object, adjust = "holm", ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} matrix of count data.}

\item{...}{Further arguments to be passed to internal methods.}

\item{simplify}{A \code{\link{logical}} scalar: should the result be
simplified to a matrix?}

\item{adjust}{A \code{\link{character}} string specifying the method for
adjusting \eqn{p} values (see \code{\link[stats]{p.adjust}}).}
}
\value{
If \code{simplify} is \code{FALSE}, returns a list (default), else returns
 a matrix.
}
\description{
Tests on Abundance Data
}
\details{
The following methods are available:
 \describe{
  \item{\code{test_diversity}}{Compare Shannon diversity between samples.
  This test produces two sided pairwise comparisons: it returns a matrix of
  adjusted \eqn{p} values.}
  \item{\code{test_fit}}{The Frequency Increment Test (Feder et al. 2014).
  This test rejects neutrality if the distribution of normalized variant
  frequency increments exhibits a mean that deviates significantly from
  zero.}
 }
}
\examples{
## Shannon diversity test
merzbach_count <- as_count(merzbach)
div <- test_diversity(merzbach_count)

## Frequency Increment Test
## Coerce the merzbach dataset to a count matrix
## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
merzbach_count <- as_count(merzbach[, keep])

## The data are grouped by phase
## We use the row names as time coordinates (roman numerals)
set_dates(merzbach_count) <- rownames(merzbach)

fit <- test_fit(merzbach_count, simplify = TRUE)
}
\references{
Feder, A. F., Kryazhimskiy, S. & Plotkin, J. B. (2014). Identifying
 Signatures of Selection in Genetic Time Series. \emph{Genetics}, 196(2),
 509-522.
 DOI: \href{https://doi.org/10.1534/genetics.113.158220}{10.1534/genetics.113.158220}.

 Magurran, A. E. (1988). \emph{Ecological Diversity and its Measurement}.
 Princeton, NJ: Princeton University Press.
 DOI: \href{https://doi.org/10.1007/978-94-015-7358-0}{10.1007/978-94-015-7358-0}.
}
\author{
N. Frerebeau
}
\concept{test}
