% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_heatmap.R
\docType{methods}
\name{plot_matrix}
\alias{plot_matrix}
\alias{matrigraphe}
\alias{plot_heatmap}
\alias{plot_heatmap-method}
\alias{plot_heatmap,matrix-method}
\title{Heatmap}
\usage{
plot_heatmap(object, ...)

\S4method{plot_heatmap}{matrix}(object)
}
\arguments{
\item{object}{An object to be plotted.}

\item{...}{Further arguments to be passed to internal methods.}
}
\value{
A \link[ggplot2:ggplot]{ggplot2::ggplot} object.
}
\description{
Plots a heatmap.
}
\examples{
## Abundance data (data from Desachy 2004)
data("compiegne", package = "folio")
## Coerce dataset to absolute frequencies
counts <- as_count(compiegne)
## Coerce dataset to relative frequencies
freq <- as_composition(compiegne)

## Plot matrix diagram...
plot_heatmap(counts)
plot_heatmap(freq)

## Presence/absence data
inc <- sample(0:1, size = 100, replace = TRUE)
bin <- IncidenceMatrix(data = inc, nrow = 10, ncol = 10)

plot_heatmap(bin) +
  ggplot2::scale_fill_manual(values = c("TRUE" = "black", "FALSE" = "white"))
}
\references{
Desachy, B. (2004). Le sériographe EPPM: un outil informatisé de sériation
graphique pour tableaux de comptages. \emph{Revue archéologique de Picardie},
3(1), 39-56. \doi{10.3406/pica.2004.2396}.
}
\seealso{
\code{\link[=pvi]{pvi()}}

Other plot: 
\code{\link{plot_bar}},
\code{\link{plot_diversity}},
\code{\link{plot_line}},
\code{\link{plot_spot}()}
}
\author{
N. Frerebeau
}
\concept{plot}
