% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_bertin.R
\docType{methods}
\name{plot_bertin}
\alias{plot_bertin}
\alias{plot_bertin-method}
\alias{Bertin}
\alias{plot_bertin,matrix-method}
\alias{plot_bertin,data.frame-method}
\title{Bertin Diagram}
\usage{
plot_bertin(object, ...)

\S4method{plot_bertin}{matrix}(
  object,
  threshold = NULL,
  freq = FALSE,
  margin = 1,
  col = c("white", "black"),
  flip = TRUE,
  axes = TRUE,
  ...
)

\S4method{plot_bertin}{data.frame}(
  object,
  threshold = NULL,
  freq = FALSE,
  margin = 1,
  col = c("white", "black"),
  flip = TRUE,
  axes = TRUE,
  ...
)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table).}

\item{...}{Currently not used.}

\item{threshold}{A \code{\link{function}} that takes a numeric vector as argument and
returns a numeric threshold value (see below). If \code{NULL} (the default), no
threshold is computed. Only used if \code{freq} is \code{FALSE}.}

\item{freq}{A \code{\link{logical}} scalar indicating whether conditional proportions
given \code{margins} should be used (i.e. entries of \code{object}, divided by the
appropriate marginal sums).}

\item{margin}{An \code{\link{integer}} vector giving the margins to split by:
\code{1} indicates individuals/rows (the default), \code{2} indicates
variables/columns. Only used if \code{freq} is \code{TRUE}.}

\item{col}{A vector of colors.}

\item{flip}{A \code{\link{logical}} scalar: should \code{x} and \code{y} axis be flipped?
Defaults to \code{TRUE}.}

\item{axes}{A \code{\link{logical}} scalar: should axes be drawn on the plot?}
}
\value{
\code{plot_bertin()} is called it for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
}
\description{
Plots a Bertin diagram.
}
\section{Bertin Matrix}{

As de Falguerolles \emph{et al.} (1997) points out:
"In abstract terms, a Bertin matrix is a matrix of  displays. \link{...} To fix
ideas, think of a data matrix, variable by case, with real valued variables.
For each variable, draw a bar chart of variable value by case. High-light
all bars representing a value above some sample threshold for that
variable."
}

\examples{
## Data from Lipo et al. 2015
data("mississippi", package = "folio")

## Plot a Bertin diagram...
## ...without threshold
plot_bertin(mississippi)

## ...with the variable mean as threshold
plot_bertin(mississippi, threshold = mean)

## Plot conditional proportions
plot_bertin(mississippi, freq = TRUE, margin = 1)
plot_bertin(mississippi, freq = TRUE, margin = 2)
}
\references{
Bertin, J. (1977). \emph{La graphique et le traitement graphique de
l'information}. Paris: Flammarion. Nouvelle Bibliothèque Scientifique.

de Falguerolles, A., Friedrich, F. & Sawitzki, G. (1997). A Tribute to J.
Bertin's Graphical Data Analysis. In W. Badilla & F. Faulbaum (eds.),
\emph{SoftStat '97: Advances in Statistical Software 6}. Stuttgart: Lucius
& Lucius, p. 11-20.
}
\seealso{
Other plot methods: 
\code{\link{matrigraph}()},
\code{\link{plot_diceleraas}()},
\code{\link{plot_diversity}},
\code{\link{plot_ford}()},
\code{\link{plot_heatmap}()},
\code{\link{plot_rank}()},
\code{\link{plot_rarefaction}},
\code{\link{plot_spot}()},
\code{\link{seriograph}()}
}
\author{
N. Frerebeau
}
\concept{plot methods}
