/*
 * Decompiled with CFR 0.152.
 */
package com.github.jaiimageio.jpeg2000.impl;

import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import jj2000.j2k.io.RandomAccessIO;

public class IISRandomAccessIO
implements RandomAccessIO {
    private ImageInputStream iis;

    public IISRandomAccessIO(ImageInputStream iis) {
        if (iis == null) {
            throw new IllegalArgumentException("iis == null!");
        }
        this.iis = iis;
    }

    @Override
    public void close() throws IOException {
        this.iis.close();
    }

    @Override
    public int getPos() throws IOException {
        long pos = this.iis.getStreamPosition();
        return pos > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pos;
    }

    @Override
    public void seek(int off) throws IOException {
        this.iis.seek(off);
    }

    @Override
    public int length() throws IOException {
        long pos;
        int numRead;
        long len = this.iis.length();
        if (len != -1L) {
            return len > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)len;
        }
        this.iis.mark();
        int bufLen = 1024;
        byte[] buf = new byte[bufLen];
        for (pos = this.iis.getStreamPosition(); pos < Integer.MAX_VALUE && (numRead = this.iis.read(buf, 0, bufLen)) != -1; pos += (long)numRead) {
        }
        this.iis.reset();
        return pos > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)pos;
    }

    @Override
    public int read() throws IOException {
        return this.iis.read();
    }

    @Override
    public void readFully(byte[] b, int off, int n) throws IOException {
        this.iis.readFully(b, off, n);
    }

    @Override
    public int getByteOrdering() {
        return this.iis.getByteOrder() == ByteOrder.BIG_ENDIAN ? 0 : 1;
    }

    @Override
    public byte readByte() throws IOException {
        return this.iis.readByte();
    }

    @Override
    public int readUnsignedByte() throws IOException {
        return this.iis.readUnsignedByte();
    }

    @Override
    public short readShort() throws IOException {
        return this.iis.readShort();
    }

    @Override
    public int readUnsignedShort() throws IOException {
        return this.iis.readUnsignedShort();
    }

    @Override
    public int readInt() throws IOException {
        return this.iis.readInt();
    }

    @Override
    public long readUnsignedInt() throws IOException {
        return this.iis.readUnsignedInt();
    }

    @Override
    public long readLong() throws IOException {
        return this.iis.readLong();
    }

    @Override
    public float readFloat() throws IOException {
        return this.iis.readFloat();
    }

    @Override
    public double readDouble() throws IOException {
        return this.iis.readDouble();
    }

    @Override
    public int skipBytes(int n) throws IOException {
        return this.iis.skipBytes(n);
    }

    @Override
    public void flush() {
    }

    @Override
    public void write(int b) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeByte(int v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeShort(int v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeInt(int v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeLong(long v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeFloat(float v) throws IOException {
        throw new IOException("Writing is not supported!");
    }

    @Override
    public void writeDouble(double v) throws IOException {
        throw new IOException("Writing is not supported!");
    }
}

