% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xyplot.forecast.R
\name{xyplot.forecast}
\alias{xyplot.forecast}
\title{Plot Forecasts with Trellis Graphics}
\usage{
\method{xyplot}{forecast}(x, data = NULL, ci = TRUE, ci_levels = x$level,
  ci_key = ci, ci_pal = hcl(0, 0, 45:100),
  ci_alpha = trellis.par.get("regions")$alpha, ...)
}
\arguments{
\item{x}{An object of class \code{forecast}.}

\item{data}{Data of observations left out of the model fit, usually
"future" observations.}

\item{ci}{Plot confidence intervals for the predictions.}

\item{ci_levels}{The prediction levels to plot as a subset of those
forecasted in \code{x}.}

\item{ci_key}{Set to \code{TRUE} to draw a key automatically or provide a list
(if \code{length(ci_levels)} > 5 should work with \code{\link[lattice:draw.colorkey]{lattice::draw.colorkey()}} and
otherwise with \code{\link[lattice:draw.key]{lattice::draw.key()}})}

\item{ci_pal}{Color palette for the confidence bands.}

\item{ci_alpha}{Fill alpha for the confidence interval.}

\item{...}{Arguments passed on to \code{\link[lattice:panel.xyplot]{lattice::panel.xyplot()}}.}
}
\value{
An object of class \code{"trellis"}. The
  \code{\link[lattice:update.trellis]{update}} method can be used to
  update components of the object and the
  \code{\link[lattice:print.trellis]{print}} method (usually called by
  default) will plot it on an appropriate plotting device.
}
\description{
Plot forecasts from \code{\link[forecast:forecast]{forecast::forecast()}}. It is built mostly to resemble
the \code{\link[forecast:autoplot.forecast]{forecast::autoplot.forecast()}} and \code{\link[forecast:plot.forecast]{forecast::plot.forecast()}}
functions, but in addition tries to plot the predictions on the original
scale.
}
\details{
This function requires the \strong{zoo} package.
}
\examples{
if (require(forecast)) {
  train <- window(USAccDeaths, c(1973, 1), c(1977, 12))
  test <- window(USAccDeaths, c(1978, 1), c(1978, 12))
  fit <- arima(train, order = c(0, 1, 1),
               seasonal = list(order = c(0, 1, 1)))
  fcast1 <- forecast(fit, 12)
  xyplot(fcast1, test, grid = TRUE, auto.key = list(corner = c(0, 0.99)),
         ci_key = list(title = "PI Level"))

  # A fan plot
  fcast2 <- forecast(fit, 12, level = seq(0, 95, 10))
  xyplot(fcast2, test, ci_pal = heat.colors(100))
}
}
\seealso{
\code{\link[lattice:panel.xyplot]{lattice::panel.xyplot()}}, \code{\link[forecast:forecast]{forecast::forecast()}}, \code{\link[lattice:xyplot.ts]{lattice::xyplot.ts()}}.
}
