% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ozawa.R
\name{OZ}
\alias{OZ}
\title{Title Ozawa model crystallization}
\usage{
OZ(mat, n.step = 1, spks = 1, eps = 0.001)
}
\arguments{
\item{mat}{matrix of the all the thermograms checked using the functiom mat.check}

\item{n.step}{number of steps for selecting temperature ranges}

\item{spks}{id of the peaks selected for applying the method}

\item{eps}{tollerance for the selection process}
}
\value{
models "mod", datable "xy" for plot, "Ea" list of value, datatable "DT" built with the values of mat according to the specified degrees
}
\description{
performs analysis of the thermograms using Ozawa method
}
\examples{
\donttest{
require(data.table)
require(MASS)
rates=c(0.5,1,2,5,10,20,50)
a<-lapply(rates, function(x) JMA(A=exp(35),Ea=120000,T0=0,T.end=300,q=x,npoints=5000,n=2))
a<-lapply(seq(1,length(a)), function(x) data.table(a[[x]]$time.s,a[[x]]$T.C,
a[[x]]$dadT, rates[[x]]))
lapply(seq(1,length(a)), function(x) setnames(a[[x]],
c("time.seconds","temperature.s","heat.flow","rates") ) )
ar<-testMat(a)
oz<-OZ(ar)
}
}
\references{
1. Ozawa T. Kinetics of non-isothermal crystallization. Polymer (Guildf). 1971;12(3):150-158. doi:10.1016/0032-3861(71)90041-3.
}
