% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkmat.R
\name{checkmat}
\alias{checkmat}
\title{Title checkmat}
\usage{
checkmat(dat, header = TRUE, selected = c(0, 1, 2, 0, 0, 0, 4, 0))
}
\arguments{
\item{dat}{MUST be a data.frame where each column represent a parameter of the thermogram you need to check}

\item{header}{present or not in your data.frame}

\item{selected}{a vector that include the coded position of the parameters present in the dataset. 0 equal not present, while if you insert a number its value will refer to
the index of the column of the input matrix where the parameter is stored. the coding of the vector selected is the following  1. "time.minutes" 2. "time.seconds" 3."temperature.s" 4."temperature.r" 5."temperature.s.K" 6."temperature.r.K"7."heat.flow"8. "id"}
}
\value{
Checked data frame
}
\description{
Title checkmat
}
\details{
i.e. selected=c(1,0,2,0,0,0,3) means that your first column is time.seconds, the second column is the temperature of the sample
	and the this column is the heat flow. 0 represents the other column of your files that are not present in your dataset
}
\examples{
npoints=1000
x=seq(1,npoints)
y=(dnorm(x, mean=npoints/2, sd=npoints/10))
x=seq(1,1000)
x2=seq(200,500,length.out=1000)
dat=data.frame(x,x2,y)
colnames(dat) <- c("time.seconds", "temperature.s","heat.flow")
cmat<- checkmat(dat,selected=c(1,0,2,0,0,0,3,0))

}
