% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/medic_helpers.R
\name{parameters_constructor}
\alias{parameters_constructor}
\title{Internal option constructor}
\usage{
parameters_constructor(
  data,
  id,
  k = 5,
  atc,
  timing,
  base_clustering,
  linkage = "complete",
  summation_method = "sum_of_minima",
  alpha = 1,
  beta = 1,
  gamma = 1,
  p = 1,
  theta = (5:0)/5,
  ...
)
}
\arguments{
\item{data}{A data frame containing all the variables for the clustering.}

\item{id}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the variable in \code{data} describing person id.}

\item{k}{a vector specifying the number of clusters to identify.}

\item{atc}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the variable in \code{data} containing ATC codes.}

\item{timing}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An unquoted
expression naming the variable or variables in \code{data} describing
medication timing. Variable names can be used as if they were positions in
the data frame, so expressions like x:y can be used to select a range of
variables. Moreover, pattern matching selection helpers such as
\code{\link[tidyselect:starts_with]{starts_with}} or
\code{\link[tidyselect:starts_with]{num_range}} may also be used to select timing
variables.}

\item{base_clustering}{<\code{\link[dplyr:dplyr_tidy_select]{tidy-select}}> An
unquoted expression naming the variable in \code{data} that gives an initial
clustering to start the \code{medic} from or \code{NULL}.}

\item{linkage}{The agglomeration method to be used in the clustering. This
should be (an unambiguous abbreviation of) one of "ward.D", "ward.D2",
"single", "complete", "average" (= UPGMA), "mcquitty" (= WPGMA), "median"
(= WPGMC) or "centroid" (= UPGMC). See \link[stats:hclust]{stats::hclust} for more
information. For a discussion of linkage criterion choice see
\emph{details} below.}

\item{summation_method}{The summation method used in the distance measure.
This  should be either "double_sum" or "sum_of_minima". See
\emph{details} below for more information.}

\item{alpha}{A number giving the tuning of the normalization. See
\emph{details} below for more information.}

\item{beta}{A number giving the power of the individual medication
combinations. See \emph{details} below for more information.}

\item{gamma}{A number giving the weight of the timing terms. See
\emph{details} below for more information.}

\item{p}{The power of the Minkowski distance used in the timing-specific
distance. See \emph{details} below for more information.}

\item{theta}{A vector of length 6 specifying the tuning of the ATC measure.
See \emph{details} below for more information.}

\item{...}{Additional arguments not currently in use.}
}
\value{
A data.frame with the parameters for clustering.
}
\description{
Given the input of the \code{medic} this function checks the
input and constructs a data frame with the analysis parameters specified by
the user.
}
\examples{
parameters_constructor(
   data = complications, 
   k = 3, 
   id = id,
   atc = atc
)

}
