% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parser.R
\docType{class}
\name{ASTVariable}
\alias{ASTVariable}
\title{A Variable in an Abstract Syntax Tree (AST)}
\format{\code{\link{R6Class}} object.}
\usage{
ASTVariable
}
\description{
This node represents a variable of interest in the AST. A variable's name
is recorded in the value field, and must conform to the rules of identifiers
in R. This class inherits from \code{\link{ASTNode}}.
}
\section{Fields}{

\describe{
\item{\code{value}}{A string containing the variable identifier}

\item{\code{format}}{A format string that is either a string containing a number representing significant digits for output, or a C-style printf string.}

\item{\code{type}}{A string that represents the type specifier for that variable}
}}

\section{Methods}{

\describe{
  \item{\code{new(identifier, format=NA, type=NA)}}{This method creates an AST node representing a variable of a given identifier. An optional format consisting of a string of a number or a c-style printf string. An option type denoting a forced type cast of that variable.}
  \item{\code{terms()}}{Returns the node}
  \item{\code{distribute()}}{Applies the distributive property to the node, and returns the resulting node.}
  \item{\code{string()}}{Returns the string formula of the node}
  \item{\code{name()}}{Return a human representation of a node}
  \item{\code{reduce(data)}}{Given a set of data, perform the logical reduction of the current node.}
}
}

\examples{
ASTVariable$new("x", "2", "Continuous")$string()

}
\keyword{data}
