% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_quarto.R
\name{tar_quarto}
\alias{tar_quarto}
\title{Target with a Quarto project.}
\usage{
tar_quarto(
  name,
  path = ".",
  extra_files = character(0),
  execute = TRUE,
  execute_params = list(),
  cache = NULL,
  cache_refresh = FALSE,
  debug = FALSE,
  quiet = TRUE,
  pandoc_args = NULL,
  tidy_eval = targets::tar_option_get("tidy_eval"),
  packages = targets::tar_option_get("packages"),
  library = targets::tar_option_get("library"),
  error = targets::tar_option_get("error"),
  memory = targets::tar_option_get("memory"),
  garbage_collection = targets::tar_option_get("garbage_collection"),
  deployment = "main",
  priority = targets::tar_option_get("priority"),
  resources = targets::tar_option_get("resources"),
  retrieval = targets::tar_option_get("retrieval"),
  cue = targets::tar_option_get("cue")
)
}
\arguments{
\item{name}{Symbol, name of the target. A target
name must be a valid name for a symbol in R, and it
must not start with a dot. Subsequent targets
can refer to this name symbolically to induce a dependency relationship:
e.g. \code{tar_target(downstream_target, f(upstream_target))} is a
target named \code{downstream_target} which depends on a target
\code{upstream_target} and a function \code{f()}. In addition, a target's
name determines its random number generator seed. In this way,
each target runs with a reproducible seed so someone else
running the same pipeline should get the same results,
and no two targets in the same pipeline share the same seed.
(Even dynamic branches have different names and thus different seeds.)
You can recover the seed of a completed target
with \code{tar_meta(your_target, seed)} and run \code{set.seed()} on the result
to locally recreate the target's initial RNG state.}

\item{path}{Character of length 1,
either the single \verb{*.qmd} source file to be rendered
or a directory containing a Quarto project.
Defaults to the working directory of the \code{targets} pipeline.
Passed directly to the \code{input} argument of \code{quarto::quarto_render()}.}

\item{extra_files}{Character vector of extra files and
directories to track for changes. The target will be invalidated
(rerun on the next \code{tar_make()}) if the contents of these files changes.
No need to include anything already in the output of \code{\link[=tar_quarto_files]{tar_quarto_files()}},
the list of file dependencies automatically detected through
\code{quarto::quarto_inspect()}.}

\item{execute}{Whether to execute embedded code chunks.}

\item{execute_params}{Code, cannot be \code{NULL}.
\code{execute_params} evaluates to a named list of parameters
for parameterized Quarto documents. These parameters override the custom
custom elements of the \code{params} list in the YAML front-matter of the
Quarto source files. The list is quoted
(not evaluated until the target runs)
so that upstream targets can serve as parameter values.}

\item{cache}{Cache execution output (uses knitr cache and jupyter-cache
respectively for Rmd and Jupyter input files).}

\item{cache_refresh}{Force refresh of execution cache.}

\item{debug}{Leave intermediate files in place after render.}

\item{quiet}{Suppress warning and other messages.}

\item{pandoc_args}{Additional command line options to pass to pandoc.}

\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target builds or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline.
}}

\item{memory}{Character of length 1, memory strategy.
If \code{"persistent"}, the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
If \code{"transient"}, the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
this memory strategy applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{Logical, whether to run \code{base::gc()}
just before the target runs.}

\item{deployment}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}. If \code{"worker"},
the target builds on a parallel worker. If \code{"main"},
the target builds on the host machine / process managing the pipeline.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get built earlier
(and polled earlier in \code{\link[targets:tar_make_future]{tar_make_future()}}).}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{retrieval}{Character of length 1, only relevant to
\code{\link[targets:tar_make_clustermq]{tar_make_clustermq()}} and \code{\link[targets:tar_make_future]{tar_make_future()}}.
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target builds.
\item \code{"worker"}: the worker loads the targets dependencies.
\item \code{"none"}: the dependencies are not loaded at all.
This choice is almost never recommended. It is only for
niche situations, e.g. the data needs to be loaded
explicitly from another language.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}
}
\value{
A target object with \code{format = "file"}.
When this target runs, it returns a character vector
of file paths: the rendered documents, the Quarto source files,
and other input and output files.
The output files are determined by the YAML front-matter of
standalone Quarto documents and \verb{_quarto.yml} in Quarto projects,
and you can see these files with \code{\link[=tar_quarto_files]{tar_quarto_files()}}
(powered by \code{quarto::quarto_inspect()}).
All returned paths are \emph{relative} paths to ensure portability
(so that the project can be moved from one file system to another
without invalidating the target).
See the "Target objects" section for background.
}
\description{
Shorthand to include a Quarto project in a
\code{targets} pipeline.
}
\details{
\code{tar_quarto()} is an alternative to \code{tar_target()} for
Quarto projects and standalone Quarto source documents
that depend on upstream targets. The Quarto
R source documents (\verb{*.qmd} and \verb{*.Rmd} files)
should mention dependency targets with \code{tar_load()} and \code{tar_read()}
in the active R code chunks (which also allows you to render the project
outside the pipeline if the \verb{_targets/} data store already exists).
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
Then, \code{tar_quarto()} defines a special kind of target. It
1. Finds all the \code{tar_load()}/\code{tar_read()} dependencies in the
R source reports and inserts them into the target's command.
This enforces the proper dependency relationships.
(Do not use \code{tar_load_raw()} or \code{tar_read_raw()} for this.)
2. Sets \code{format = "file"} (see \code{tar_target()}) so \code{targets}
watches the files at the returned paths and reruns the report
if those files change.
3. Configures the target's command to return both the output
rendered files and the input dependency files (such as
Quarto source documents). All these file paths
are relative paths so the project stays portable.
4. Forces the report to run in the user's current working directory
instead of the working directory of the report.
5. Sets convenient default options such as \code{deployment = "main"}
in the target and \code{quiet = TRUE} in \code{quarto::quarto_render()}.
}
\section{Target objects}{

Most \code{tarchetypes} functions are target factories,
which means they return target objects
or lists of target objects.
Target objects represent skippable steps of the analysis pipeline
as described at \url{https://books.ropensci.org/targets/}.
Please read the walkthrough at
\url{https://books.ropensci.org/targets/walkthrough.html}
to understand the role of target objects in analysis pipelines.

For developers,
\url{https://wlandau.github.io/targetopia/contributing.html#target-factories}
explains target factories (functions like this one which generate targets)
and the design specification at
\url{https://books.ropensci.org/targets-design/}
details the structure and composition of target objects.
}

\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
targets::tar_dir({  # tar_dir() runs code from a temporary directory.
# Unparameterized Quarto document:
lines <- c(
  "---",
  "title: report.qmd source file",
  "output_format: html",
  "---",
  "Assume these lines are in report.qmd.",
  "```{r}",
  "targets::tar_read(data)",
  "```"
)
writeLines(lines, "report.qmd")
# Include the report in a pipeline as follows.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_quarto(report, path = "report.qmd")
  )
}, ask = FALSE)
# Then, run the pipeline as usual.

# Parameterized Quarto:
lines <- c(
  "---",
  "title: 'report.qmd source file with parameters'",
  "output_format: html_document",
  "params:",
  "  your_param: \"default value\"",
  "---",
  "Assume these lines are in report.qmd.",
  "```{r}",
  "print(params$your_param)",
  "```"
)
writeLines(lines, "report.qmd")
# Include the report in the pipeline as follows.
unlink("_targets.R") # In tar_dir(), not the user's file space.
targets::tar_script({
  library(tarchetypes)
  list(
    tar_target(data, data.frame(x = seq_len(26), y = letters)),
    tar_quarto(
      report,
      path = "report.qmd",
      execute_params = list(your_param = data)
    )
  )
}, ask = FALSE)
})
# Then, run the pipeline as usual.
}
}
\seealso{
Other Literate programming targets: 
\code{\link{tar_knit_raw}()},
\code{\link{tar_knit}()},
\code{\link{tar_quarto_raw}()},
\code{\link{tar_quarto_rep_raw}()},
\code{\link{tar_quarto_rep}()},
\code{\link{tar_render_raw}()},
\code{\link{tar_render_rep_raw}()},
\code{\link{tar_render_rep}()},
\code{\link{tar_render}()}
}
\concept{Literate programming targets}
