% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_model.R
\name{ml_model}
\alias{ml_model}
\title{R6 class for prediction models}
\description{
R6 class for prediction models

R6 class for prediction models
}
\details{
Provides standardized estimation and prediction methods
}
\examples{
data(iris)
rf <- function(formula, ...)
ml_model$new(formula, info="grf::probability_forest",
             estimate=function(x,y, ...) grf::probability_forest(X=x, Y=y, ...),
             predict=function(object, newdata) predict(object, newdata)$predictions, ...)

args <- expand.list(num.trees=c(100,200), mtry=1:3,
                   formula=c(Species ~ ., Species ~ Sepal.Length + Sepal.Width))
models <- lapply(args, function(par) do.call(rf, par))

x <- models[[1]]$clone()
x$estimate(iris)
predict(x, newdata=head(iris))

\donttest{ # Reduce Ex. timing
a <- targeted::cv(models, data=iris)
cbind(coef(a), attr(args, "table"))
}

ff <- ml_model$new(estimate=function(y,x) lm.fit(x=x, y=y),
                   predict=function(object, newdata) newdata\%*\%object$coefficients)
## tmp <- ff$estimate(y, x=x)
## ff$predict(x)
}
\author{
Klaus Kähler Holst
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{info}}{Optional information/name of the model}

\item{\code{formals}}{List with formal arguments of estimation and prediction functions}

\item{\code{formula}}{Formula specifying response and design matrix}

\item{\code{args}}{additional arguments specified during initialization}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{fit}}{Active binding returning estimated model object}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ml_model-new}{\code{ml_model$new()}}
\item \href{#method-ml_model-estimate}{\code{ml_model$estimate()}}
\item \href{#method-ml_model-predict}{\code{ml_model$predict()}}
\item \href{#method-ml_model-update}{\code{ml_model$update()}}
\item \href{#method-ml_model-print}{\code{ml_model$print()}}
\item \href{#method-ml_model-response}{\code{ml_model$response()}}
\item \href{#method-ml_model-design}{\code{ml_model$design()}}
\item \href{#method-ml_model-opt}{\code{ml_model$opt()}}
\item \href{#method-ml_model-clone}{\code{ml_model$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-new"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-new}{}}}
\subsection{Method \code{new()}}{
Create a new prediction model object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$new(
  formula = NULL,
  estimate,
  predict = stats::predict,
  predict.args = NULL,
  info = NULL,
  specials,
  response.arg = "y",
  x.arg = "x",
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{formula specifying outcome and design matrix}

\item{\code{estimate}}{function for fitting the model (must be a function response, 'y',
and design matrix, 'x'. Alternatively, a function with a single 'formula' argument)}

\item{\code{predict}}{prediction function (must be a function of model object, 'object',
and new design matrix, 'newdata')}

\item{\code{predict.args}}{optional arguments to prediction function}

\item{\code{info}}{optional description of the model}

\item{\code{specials}}{optional additional terms (weights, offset, id, subset, ...)
passed to 'estimate'}

\item{\code{response.arg}}{name of response argument}

\item{\code{x.arg}}{name of design matrix argument}

\item{\code{...}}{optional arguments to fitting function}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-estimate"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-estimate}{}}}
\subsection{Method \code{estimate()}}{
Estimation method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$estimate(data, ..., store = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame}

\item{\code{...}}{Additional arguments to estimation method}

\item{\code{store}}{Logical determining if estimated model should be stored inside the class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-predict"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-predict}{}}}
\subsection{Method \code{predict()}}{
Prediction method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$predict(newdata, ..., object = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{newdata}}{data.frame}

\item{\code{...}}{Additional arguments to prediction method}

\item{\code{object}}{Optional model fit object}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-update"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-update}{}}}
\subsection{Method \code{update()}}{
Update formula
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$update(formula, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{formula}}{formula or character which defines the new response}

\item{\code{...}}{Additional arguments to lower level functions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-print"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-print}{}}}
\subsection{Method \code{print()}}{
Print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Additional arguments to lower level functions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-response"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-response}{}}}
\subsection{Method \code{response()}}{
Extract response from data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$response(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame}

\item{\code{...}}{additional arguments to 'design'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-design"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-design}{}}}
\subsection{Method \code{design()}}{
Extract design matrix (features) from data
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$design(data, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{data}}{data.frame}

\item{\code{...}}{additional arguments to 'design'}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-opt"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-opt}{}}}
\subsection{Method \code{opt()}}{
Get options
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$opt(arg, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arg}}{name of option to get value of}

\item{\code{...}}{additional arguments to lower level functions}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ml_model-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ml_model-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ml_model$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
