% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_glimpse.R
\name{tar_glimpse}
\alias{tar_glimpse}
\title{Visualize an abridged fast dependency graph.}
\usage{
tar_glimpse(
  targets_only = TRUE,
  names = NULL,
  shortcut = FALSE,
  allow = NULL,
  exclude = ".Random.seed",
  level_separation = NULL,
  degree_from = 1L,
  degree_to = 1L,
  zoom_speed = 1,
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function),
  envir = parent.frame(),
  script = targets::tar_config_get("script"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{targets_only}{Logical, whether to restrict the output to just targets
(\code{FALSE}) or to also include global functions and objects.}

\item{names}{Names of targets. The graph visualization will operate
only on these targets (and unless \code{shortcut} is \code{TRUE},
all the targets upstream as well). Selecting a small subgraph
using \code{names} could speed up the load time of the visualization.
Unlike \code{allow}, \code{names} is invoked before the graph
is generated.
Set to NULL to check/build all the targets (default).
Otherwise, you can supply symbols or tidyselect helpers
like starts_with().
Applies to ordinary targets (stem) and whole dynamic branching
targets (patterns) but not individual dynamic branches.}

\item{shortcut}{Logical of length 1, how to interpret the \code{names} argument.
If \code{shortcut} is \code{FALSE} (default) then the function checks
all targets upstream of \code{names} as far back as the dependency graph goes.
If \code{TRUE}, then the function only checks the targets in \code{names}
and uses stored metadata for information about upstream dependencies
as needed. \code{shortcut = TRUE} increases speed if there are a lot of
up-to-date targets, but it assumes all the dependencies
are up to date, so please use with caution.
Also, \code{shortcut = TRUE} only works if you set \code{names}.}

\item{allow}{Optional, define the set of allowable vertices in the graph.
Unlike \code{names}, \code{allow} is invoked only after the graph is mostly
resolved, so it will not speed up execution.
Set to \code{NULL} to allow all vertices in the pipeline and environment
(default). Otherwise, you can supply symbols or
\code{tidyselect} helpers like \code{\link[=starts_with]{starts_with()}}.}

\item{exclude}{Optional, define the set of exclude vertices from the graph.
Unlike \code{names}, \code{exclude} is invoked only after the graph is mostly
resolved, so it will not speed up execution.
Set to \code{NULL} to exclude no vertices.
Otherwise, you can supply symbols or \code{tidyselect}
helpers like \code{\link[=any_of]{any_of()}} and \code{\link[=starts_with]{starts_with()}}.}

\item{level_separation}{Numeric of length 1,
\code{levelSeparation} argument of \code{visNetwork::visHierarchicalLayout()}.
Controls the distance between hierarchical levels.
Consider changing the value if the aspect ratio of the graph
is far from 1. If \code{level_separation} is \code{NULL},
the \code{levelSeparation} argument of \code{visHierarchicalLayout()}
defaults to \code{150}.}

\item{degree_from}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_from}
controls the number of edges the neighborhood extends upstream.}

\item{degree_to}{Integer of length 1. When you click on a node,
the graph highlights a neighborhood of that node. \code{degree_to}
controls the number of edges the neighborhood extends downstream.}

\item{zoom_speed}{Positive numeric of length 1, scaling factor on the
zoom speed. Above 1 zooms faster than default, below 1 zooms
lower than default.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
A \code{visNetwork} HTML widget object.
}
\description{
Analyze the pipeline defined in the target script file
(default: \verb{_targets.R})
and visualize the directed acyclic graph of targets.
Unlike \code{\link[=tar_visnetwork]{tar_visnetwork()}}, \code{tar_glimpse()} does not account for
metadata or progress information, which means the graph
renders faster. Also, \code{tar_glimpse()} omits functions and other global
objects by default (but you can include them with \code{targets_only = FALSE}).
}
\examples{
if (identical(Sys.getenv("TAR_INTERACTIVE_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script({
  tar_option_set()
  list(
    tar_target(y1, 1 + 1),
    tar_target(y2, 1 + 1),
    tar_target(z, y1 + y2)
  )
}, ask = FALSE)
tar_glimpse()
tar_glimpse(allow = starts_with("y")) # see also any_of()
})
}
}
\seealso{
Other visualize: 
\code{\link{tar_mermaid}()},
\code{\link{tar_visnetwork}()}
}
\concept{visualize}
