% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_workspace.R
\name{tar_workspace}
\alias{tar_workspace}
\title{Load a saved workspace and seed for debugging.}
\usage{
tar_workspace(name, envir = parent.frame(), packages = TRUE, source = TRUE)
}
\arguments{
\item{name}{Symbol, name of the target whose workspace to read.}

\item{envir}{Environment in which to put the objects.}

\item{packages}{Logical, whether to load the required packages
of the target.}

\item{source}{Logical, whether to run \verb{_targets.R} to load user-defined
global object dependencies into \code{envir}. If \code{TRUE}, then \code{envir}
should either be the global environment or inherit from the
global environment.}
}
\value{
This function returns \code{NULL}, but it does load
the target's required packages, as well as multiple objects
into the environment (\code{envir} argument) in order to replicate the
workspace where the error happened. These objects include
the global objects at the time \code{\link[=tar_make]{tar_make()}} was called and the
dependency targets. The random number generator seed for the
target is also assigned with \code{set.seed()}
}
\description{
Load the packages, workspace, and random number generator seed
of target attempted with a workspace file.
}
\details{
If you set \code{error = "workspace"} in \code{\link[=tar_option_set]{tar_option_set()}}
or \code{\link[=tar_target]{tar_target()}}, then if that target throws an error
in \code{\link[=tar_make]{tar_make()}}, it will save its workspace to an RDS file
in \verb{_targets/workspaces/}. Workspaces also get saved for targets
supplied to the \code{workspace} argument of \code{\link[=tar_option_set]{tar_option_set()}},
even individual branches. The workspace is a compact reference
that allows \code{tar_workspace()} to load the target's dependencies
and random number generator seed as long as the data objects
are still in the data store (usually files in \verb{_targets/objects/}).
When you are done debugging, you can remove the workspace files
using \code{tar_destroy(destroy = "workspaces")}.
}
\examples{
if (identical(Sys.getenv("TAR_LONG_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tmp <- sample(1)
tar_script({
  tar_option_set(error = "workspace")
  list(
    tar_target(x, "loaded"),
    tar_target(y, stop(x))
  )
}, ask = FALSE)
# The following code throws an error for demonstration purposes.
try(tar_make())
exists("x") # Should be FALSE.
tail(.Random.seed) # for comparison to the RNG state after tar_workspace(y)
tar_workspace(y)
exists("x") # Should be TRUE.
print(x) # "loaded"
# Should be different: tar_workspace() runs set.seed(tar_meta(y, seed)$seed)
tail(.Random.seed)
})
}
}
\seealso{
Other debug: 
\code{\link{tar_traceback}()},
\code{\link{tar_workspaces}()}
}
\concept{debug}
