% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_read_raw.R
\name{tar_read_raw}
\alias{tar_read_raw}
\title{Read a target's value from storage (raw version)}
\usage{
tar_read_raw(
  name,
  branches = NULL,
  meta = tar_meta(store = store),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Character, name of the target to read.}

\item{branches}{Integer of indices of the branches to load
if the target is a pattern.}

\item{meta}{Data frame of metadata from \code{\link[=tar_meta]{tar_meta()}}.
\code{tar_read()} with the default arguments can be inefficient for large
pipelines because all the metadata is stored in a single file.
However, if you call \code{\link[=tar_meta]{tar_meta()}} beforehand and supply it to the \code{meta}
argument, then successive calls to \code{tar_read()} may run much faster.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
The target's return value from its file in
\verb{_targets/objects/}, or the paths to the custom files and directories
if \code{format = "file"} was set.
}
\description{
Like \code{\link[=tar_read]{tar_read()}} except \code{name} is a character string.
Do not use in \code{knitr} or R Markdown reports with \code{tarchetypes::tar_knit()}
or \code{tarchetypes::tar_render()}.
}
\section{Limited scope}{

\code{tar_read()} and \code{tar_load()}
are only for exploratory analysis and literate programming,
and \code{tar_read_raw()} and \code{tar_load_raw()} are only
for exploratory analysis. \code{targets} automatically
loads the correct dependencies into memory when the pipeline
is running, so invoking these functions
from inside a target is rarely advisable.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) {
tar_dir({ # tar_dir() runs code from a temporary directory.
tar_script(list(tar_target(x, 1 + 1)), ask = FALSE)
tar_make()
tar_read_raw("x")
})
}
}
\seealso{
Other data: 
\code{\link{tar_load_raw}()},
\code{\link{tar_load}()},
\code{\link{tar_meta}()},
\code{\link{tar_objects}()},
\code{\link{tar_pid}()},
\code{\link{tar_process}()},
\code{\link{tar_read}()}
}
\concept{data}
