% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_traceback.R
\name{tar_traceback}
\alias{tar_traceback}
\title{Get a target's traceback}
\usage{
tar_traceback(
  name,
  envir = NULL,
  packages = NULL,
  source = NULL,
  characters = getOption("width"),
  store = targets::tar_config_get("store")
)
}
\arguments{
\item{name}{Symbol, name of the target whose workspace to read.}

\item{envir}{Deprecated in \code{targets} > 0.3.1 (2021-03-28).}

\item{packages}{Logical, whether to load the required packages
of the target.}

\item{source}{Logical, whether to run the target script file
(default: \verb{_targets.R}) to load user-defined
global object dependencies into \code{envir}. If \code{TRUE}, then \code{envir}
should either be the global environment or inherit from the
global environment.}

\item{characters}{Positive integer. Each line of the traceback
is shortened to this number of characters.}

\item{store}{Character of length 1, path to the
\code{targets} data store. Defaults to \code{tar_config_get("store")},
which in turn defaults to \verb{_targets/}.
When you set this argument, the value of \code{tar_config_get("store")}
is temporarily changed for the current function call.
See \code{\link[=tar_config_get]{tar_config_get()}} and \code{\link[=tar_config_set]{tar_config_set()}} for details
about how to set the data store path persistently
for a project.}
}
\value{
Character vector, the traceback of a failed target
if it exists.
}
\description{
Return the saved traceback of a target.
Assumes the target errored out in a previous run of the pipeline
with workspaces enabled for that target.
See \code{\link[=tar_workspace]{tar_workspace()}} for details.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tmp <- sample(1)
tar_script({
  tar_option_set(workspace_on_error = TRUE)
  list(
    tar_target(x, "loaded"),
    tar_target(y, stop(x))
  )
}, ask = FALSE)
try(tar_make())
tar_traceback(y, characters = 60)
})
}
}
\seealso{
Other debug: 
\code{\link{tar_load_globals}()},
\code{\link{tar_workspaces}()},
\code{\link{tar_workspace}()}
}
\concept{debug}
