% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_option_set.R
\name{tar_option_set}
\alias{tar_option_set}
\title{Set target options.}
\usage{
tar_option_set(
  tidy_eval = NULL,
  packages = NULL,
  imports = NULL,
  library = NULL,
  envir = NULL,
  format = NULL,
  repository = NULL,
  repository_meta = NULL,
  iteration = NULL,
  error = NULL,
  memory = NULL,
  garbage_collection = NULL,
  deployment = NULL,
  priority = NULL,
  backoff = NULL,
  resources = NULL,
  storage = NULL,
  retrieval = NULL,
  cue = NULL,
  description = NULL,
  debug = NULL,
  workspaces = NULL,
  workspace_on_error = NULL,
  seed = NULL,
  controller = NULL,
  trust_timestamps = NULL,
  trust_object_timestamps = NULL
)
}
\arguments{
\item{tidy_eval}{Logical, whether to enable tidy evaluation
when interpreting \code{command} and \code{pattern}. If \code{TRUE}, you can use the
"bang-bang" operator \verb{!!} to programmatically insert
the values of global objects.}

\item{packages}{Character vector of packages to load right before
the target runs or the output data is reloaded for
downstream targets. Use \code{tar_option_set()} to set packages
globally for all subsequent targets you define.}

\item{imports}{Character vector of package names.
For every package listed, \code{targets} tracks every
dataset and every object in the package namespace
as if it were part of the global namespace.
As an example, say you have a package called \code{customAnalysisPackage}
which contains an object called \code{analysis_function()}.
If you write \code{tar_option_set(imports = "yourAnalysisPackage")} in your
target script file (default: \verb{_targets.R}),
then a function called \code{"analysis_function"} will show up in the
\code{\link[=tar_visnetwork]{tar_visnetwork()}} graph, and any targets or functions
referring to the symbol \code{"analysis_function"} will depend on the
function \code{analysis_function()} from package \code{yourAnalysisPackage}.
This is best combined with
\code{tar_option_set(packages = "yourAnalysisPackage")} so
that \code{analysis_function()} can actually be called in your code.

There are several important limitations:
1. Namespaced calls, e.g. \code{yourAnalysisPackage::analysis_function()},
are ignored because of the limitations in \code{codetools::findGlobals()}
which powers the static code analysis capabilities of \code{targets}.
2. The \code{imports} option only looks at R objects and R code.
It not account for low-level compiled code
such as C/C++ or Fortran.
3. If you supply multiple packages,
e.g. \code{tar_option_set(imports = c("p1", "p2"))}, then the objects in
\code{p1} override the objects in \code{p2} if there are name conflicts.
4. Similarly, objects in \code{tar_option_get("envir")} override
everything in \code{tar_option_get("imports")}.}

\item{library}{Character vector of library paths to try
when loading \code{packages}.}

\item{envir}{Environment containing functions and global objects
common to all targets in the pipeline.
The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related functions
always overrides the current value of \code{tar_option_get("envir")}
in the current R session just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.

If \code{envir} is the global environment, all the promise objects
are diffused before sending the data to parallel workers
in \code{\link[=tar_make_future]{tar_make_future()}} and \code{\link[=tar_make_clustermq]{tar_make_clustermq()}},
but otherwise the environment is unmodified.
This behavior improves performance by decreasing
the size of data sent to workers.

If \code{envir} is not the global environment, then it should at least inherit
from the global environment or base environment
so \code{targets} can access attached packages.
In the case of a non-global \code{envir}, \code{targets} attempts to remove
potentially high memory objects that come directly from \code{targets}.
That includes \code{tar_target()} objects of class \code{"tar_target"},
as well as objects of class \code{"tar_pipeline"} or \code{"tar_algorithm"}.
This behavior improves performance by decreasing
the size of data sent to workers.

Package environments should not be assigned to \code{envir}.
To include package objects as upstream dependencies in the pipeline,
assign the package to the \code{packages} and \code{imports} arguments
of \code{tar_option_set()}.}

\item{format}{Optional storage format for the target's return value.
With the exception of \code{format = "file"}, each target
gets a file in \verb{_targets/objects}, and each format is a different
way to save and load this file. See the "Storage formats" section
for a detailed list of possible data storage formats.}

\item{repository}{Character of length 1, remote repository for target
storage. Choices:
\itemize{
\item \code{"local"}: file system of the local machine.
\item \code{"aws"}: Amazon Web Services (AWS) S3 bucket. Can be configured
with a non-AWS S3 bucket using the \code{endpoint} argument of
\code{\link[=tar_resources_aws]{tar_resources_aws()}}, but versioning capabilities may be lost
in doing so.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item \code{"gcp"}: Google Cloud Platform storage bucket.
See the cloud storage section of
\url{https://books.ropensci.org/targets/data.html}
for details for instructions.
\item A character string from \code{\link[=tar_repository_cas]{tar_repository_cas()}} for content-addressable
storage.
}

Note: if \code{repository} is not \code{"local"} and \code{format} is \code{"file"}
then the target should create a single output file.
That output file is uploaded to the cloud and tracked for changes
where it exists in the cloud. The local file is deleted after
the target runs.}

\item{repository_meta}{Character of length 1 with the same values as
\code{repository} but excluding content-addressable storage
(\code{"aws"}, \code{"gcp"}, \code{"local"}). Cloud repository
for the metadata text files in \verb{_targets/meta/}, including target
metadata and progress data. Defaults to \code{tar_option_get("repository")}
except in the case of content-addressable storage (CAS).
When \code{tar_option_get("repository")} is a CAS repository,
the default value of \code{repository_meta} is \code{"local"}.}

\item{iteration}{Character of length 1, name of the iteration mode
of the target. Choices:
\itemize{
\item \code{"vector"}: branching happens with \code{vctrs::vec_slice()} and
aggregation happens with \code{vctrs::vec_c()}.
\item \code{"list"}, branching happens with \verb{[[]]} and aggregation happens with
\code{list()}.
\item \code{"group"}: \code{dplyr::group_by()}-like functionality to branch over
subsets of a non-dynamic data frame.
For \code{iteration = "group"}, the target must not by dynamic
(the \code{pattern} argument of \code{\link[=tar_target]{tar_target()}} must be left \code{NULL}).
The target's return value must be a data
frame with a special \code{tar_group} column of consecutive integers
from 1 through the number of groups. Each integer designates a group,
and a branch is created for each collection of rows in a group.
See the \code{\link[=tar_group]{tar_group()}} function to see how you can
create the special \code{tar_group} column with \code{dplyr::group_by()}.
}}

\item{error}{Character of length 1, what to do if the target
stops and throws an error. Options:
\itemize{
\item \code{"stop"}: the whole pipeline stops and throws an error.
\item \code{"continue"}: the whole pipeline keeps going.
\item \code{"null"}: The errored target continues and returns \code{NULL}.
The data hash is deliberately wrong so the target is not
up to date for the next run of the pipeline. In addition,
as of \code{targets} version 1.8.0.9011, a value of \code{NULL} is given
to upstream dependencies with \code{error = "null"} if loading fails.
\item \code{"abridge"}: any currently running targets keep running,
but no new targets launch after that.
\item \code{"trim"}: all currently running targets stay running. A queued
target is allowed to start if:
\enumerate{
\item It is not downstream of the error, and
\item It is not a sibling branch from the same \code{\link[=tar_target]{tar_target()}} call
(if the error happened in a dynamic branch).
}

The idea is to avoid starting any new work that the immediate error
impacts. \code{error = "trim"} is just like \code{error = "abridge"},
but it allows potentially healthy regions of the dependency graph
to begin running.
(Visit \url{https://books.ropensci.org/targets/debugging.html}
to learn how to debug targets using saved workspaces.)
}}

\item{memory}{Character of length 1, memory strategy. Possible values:
\itemize{
\item \code{"auto"}: new in \code{targets} version 1.8.0.9011, \code{memory = "auto"}
is equivalent to \code{memory = "transient"} for dynamic branching
(a non-null \code{pattern} argument) and \code{memory = "persistent"}
for targets that do not use dynamic branching.
\item \code{"persistent"}: the target stays in memory
until the end of the pipeline (unless \code{storage} is \code{"worker"},
in which case \code{targets} unloads the value from memory
right after storing it in order to avoid sending
copious data over a network).
\item \code{"transient"}: the target gets unloaded
after every new target completes.
Either way, the target gets automatically loaded into memory
whenever another target needs the value.
}

For cloud-based dynamic files
(e.g. \code{format = "file"} with \code{repository = "aws"}),
the \code{memory} option applies to the
temporary local copy of the file:
\code{"persistent"} means it remains until the end of the pipeline
and is then deleted,
and \code{"transient"} means it gets deleted as soon as possible.
The former conserves bandwidth,
and the latter conserves local storage.}

\item{garbage_collection}{A non-negative integer.
If \code{0}, do not run garbage collection.
If \code{1}, run garbage collection on every target
that is not skipped, both
locally and on all parallel workers.
If \code{garbage_collection} is a positive integer \code{n}, then garbage
collection runs every \code{n}'th target that is not skipped.
For example, \code{garbage_collection = 3} will run garbage collection
on every third active target, both locally and on all parallel workers.}

\item{deployment}{Character of length 1. If \code{deployment} is
\code{"main"}, then the target will run on the central controlling R process.
Otherwise, if \code{deployment} is \code{"worker"} and you set up the pipeline
with distributed/parallel computing, then
the target runs on a parallel worker. For more on distributed/parallel
computing in \code{targets}, please visit
\url{https://books.ropensci.org/targets/crew.html}.}

\item{priority}{Numeric of length 1 between 0 and 1. Controls which
targets get deployed first when multiple competing targets are ready
simultaneously. Targets with priorities closer to 1 get dispatched earlier
(and polled earlier in \code{\link[=tar_make_future]{tar_make_future()}}).}

\item{backoff}{An object from \code{\link[=tar_backoff]{tar_backoff()}} configuring the exponential
backoff algorithm of the pipeline. See \code{\link[=tar_backoff]{tar_backoff()}} for details.
A numeric argument for \code{backoff} is still allowed, but deprecated.}

\item{resources}{Object returned by \code{tar_resources()}
with optional settings for high-performance computing
functionality, alternative data storage formats,
and other optional capabilities of \code{targets}.
See \code{tar_resources()} for details.}

\item{storage}{Character string to control when the output of the target
is saved to storage. Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's return value is sent back to the
host machine and saved/uploaded locally.
\item \code{"worker"}: the worker saves/uploads the value.
\item \code{"none"}: \code{targets} makes no attempt to save the result
of the target to storage in the location where \code{targets}
expects it to be. Saving to storage is the responsibility
of the user. Use with caution.
}}

\item{retrieval}{Character string to control when the current target
loads its dependencies into memory before running.
(Here, a "dependency" is another target upstream that the current one
depends on.) Only relevant when using \code{targets}
with parallel workers (\url{https://books.ropensci.org/targets/crew.html}).
Must be one of the following values:
\itemize{
\item \code{"main"}: the target's dependencies are loaded on the host machine
and sent to the worker before the target runs.
\item \code{"worker"}: the worker loads the target's dependencies.
\item \code{"none"}: \code{targets} makes no attempt to load its
dependencies. With \code{retrieval = "none"}, loading dependencies
is the responsibility of the user. Use with caution.
}}

\item{cue}{An optional object from \code{tar_cue()} to customize the
rules that decide whether the target is up to date.}

\item{description}{Character of length 1, a custom free-form human-readable
text description of the target. Descriptions appear as target labels
in functions like \code{\link[=tar_manifest]{tar_manifest()}} and \code{\link[=tar_visnetwork]{tar_visnetwork()}},
and they let you select subsets of targets for the \code{names} argument of
functions like \code{\link[=tar_make]{tar_make()}}. For example,
\code{tar_manifest(names = tar_described_as(starts_with("survival model")))}
lists all the targets whose descriptions start with the character
string \code{"survival model"}.}

\item{debug}{Character vector of names of targets to run in debug mode.
To use effectively, you must set \code{callr_function = NULL} and
restart your R session just before running. You should also
\code{\link[=tar_make]{tar_make()}}, \code{\link[=tar_make_clustermq]{tar_make_clustermq()}}, or \code{\link[=tar_make_future]{tar_make_future()}}.
For any target mentioned in \code{debug}, \code{targets} will force the target to
run locally (with \code{tar_cue(mode = "always")} and \code{deployment = "main"}
in the settings) and pause in an interactive debugger to help you diagnose
problems. This is like inserting a \code{browser()} statement at the
beginning of the target's expression, but without invalidating any
targets.}

\item{workspaces}{Character vector of target names.
Could be non-branching targets, whole dynamic branching targets,
or individual branch names. \code{\link[=tar_make]{tar_make()}} and friends
will save workspace files for these targets even if
the targets are skipped. Workspace files help with debugging.
See \code{\link[=tar_workspace]{tar_workspace()}} for details about workspaces.}

\item{workspace_on_error}{Logical of length 1, whether to save
a workspace file for each target that throws an error.
Workspace files help with debugging.
See \code{\link[=tar_workspace]{tar_workspace()}} for details about workspaces.}

\item{seed}{Integer of length 1, seed for generating
target-specific pseudo-random number generator seeds.
These target-specific seeds are deterministic and depend on
\code{tar_option_get("seed")} and the target name. Target-specific seeds
are safely and reproducibly applied to each target's command,
and they are stored in the metadata and retrievable with
\code{\link[=tar_meta]{tar_meta()}} or \code{\link[=tar_seed]{tar_seed()}}.

Either the user or third-party packages built on top of \code{targets}
may still set seeds inside the command of a target.
For example, some target factories in the
\code{tarchetypes} package assigns replicate-specific
seeds for the purposes of reproducible within-target batched replication.
In cases like these, the effect of the target-specific seed saved
in the metadata becomes irrelevant and the seed defined in the command
applies.

The \code{seed} option can also be \code{NA} to disable
automatic seed-setting. Any targets defined while
\code{tar_option_get("seed")} is \code{NA} will not set a seed.
In this case, those targets will never be up to date
unless they have \code{cue = tar_cue(seed = FALSE)}.}

\item{controller}{A controller or controller group object
produced by the \code{crew} R package. \code{crew} brings auto-scaled
distributed computing to \code{\link[=tar_make]{tar_make()}}.}

\item{trust_timestamps}{Logical of length 1, whether to use
file system modification timestamps to check whether the target output
data files in are up to date. This is an advanced
setting and usually does not need to be set by the user
except on old or difficult platforms.

If \code{trust_timestamps} was reset with \code{\link[=tar_option_reset]{tar_option_reset()}}
or never set at all (recommended)
then \code{targets} makes a decision based on the type of file system
of the given file.

If \code{trust_timestamps}
is \code{TRUE} (default), then \code{targets} looks at the timestamp first.
If it agrees with the timestamp recorded in the metadata, then \code{targets}
considers the file unchanged. If the timestamps disagree, then \code{targets}
recomputes the hash to make a final determination.
This practice reduces the number of hash computations
and thus saves time.

However, timestamp precision varies from a few
nanoseconds at best to 2 entire seconds at worst, and timestamps
with poor precision should not be fully trusted if there is any
possibility that you will manually change the file within 2 seconds
after the pipeline finishes.
If the data store is on a file system with low-precision timestamps,
then you may
consider setting \code{trust_timestamps} to \code{FALSE} so \code{targets}
errs on the safe side and always recomputes the hashes of files.

To check if your
file system has low-precision timestamps, you can run
\verb{file.create("x"); nanonext::msleep(1); file.create("y");}
from within the directory containing the \verb{_targets} data store
and then check
\code{difftime(file.mtime("y"), file.mtime("x"), units = "secs")}.
If the value from \code{difftime()} is around 0.001 seconds
(must be strictly above 0 and below 1) then you do not need to set
\code{trust_timestamps = FALSE}.}

\item{trust_object_timestamps}{Deprecated. Use \code{trust_timestamps} instead.}
}
\value{
\code{NULL} (invisibly).
}
\description{
Set target options, including default arguments to
\code{\link[=tar_target]{tar_target()}} such as packages, storage format,
iteration type, and cue. Only the non-null arguments are actually
set as options. See currently set options with \code{\link[=tar_option_get]{tar_option_get()}}.
To use \code{tar_option_set()} effectively, put it in your workflow's
target script file (default: \verb{_targets.R})
before calls to \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_target_raw]{tar_target_raw()}}.
}
\section{Storage formats}{

\code{targets} has several built-in storage formats to control how return
values are saved and loaded from disk:
\itemize{
\item \code{"rds"}: Default, uses \code{saveRDS()} and \code{readRDS()}. Should work for
most objects, but slow.
\item \code{"auto"}: either \code{"file"} or \code{"qs"}, depending on the return value
of the target. If the return value is a character vector of
existing files (and/or directories), then the format becomes
\code{"file"} before \code{\link[=tar_make]{tar_make()}} saves the target. Otherwise,
the format becomes \code{"qs"}.
\item \code{"qs"}: Uses \code{qs2::qs_save()} and \code{qs2::qs_read()}. Should work for
most objects, much faster than \code{"rds"}. Optionally configure settings
through \code{tar_resources()} and \code{tar_resources_qs()}.

Prior to \code{targets} version 1.8.0.9014, \code{format = "qs"} used the \code{qs}
package. \code{qs} has since been superseded in favor of \code{qs2}, and so
later versions of \code{targets} use \code{qs2} to save new data. To read
existing data, \code{targets} first attempts \code{\link[qs2:qs_read]{qs2::qs_read()}}, and then if
that fails, it falls back on \code{\link[qs:qread]{qs::qread()}}.
\item \code{"feather"}: Uses \code{arrow::write_feather()} and
\code{arrow::read_feather()} (version 2.0). Much faster than \code{"rds"},
but the value must be a data frame. Optionally set
\code{compression} and \code{compression_level} in \code{arrow::write_feather()}
through \code{tar_resources()} and \code{tar_resources_feather()}.
Requires the \code{arrow} package (not installed by default).
\item \code{"parquet"}: Uses \code{arrow::write_parquet()} and
\code{arrow::read_parquet()} (version 2.0). Much faster than \code{"rds"},
but the value must be a data frame. Optionally set
\code{compression} and \code{compression_level} in \code{arrow::write_parquet()}
through \code{tar_resources()} and \code{tar_resources_parquet()}.
Requires the \code{arrow} package (not installed by default).
\item \code{"fst"}: Uses \code{fst::write_fst()} and \code{fst::read_fst()}.
Much faster than \code{"rds"}, but the value must be
a data frame. Optionally set the compression level for
\code{fst::write_fst()} through \code{tar_resources()} and \code{tar_resources_fst()}.
Requires the \code{fst} package (not installed by default).
\item \code{"fst_dt"}: Same as \code{"fst"}, but the value is a \code{data.table}.
Deep copies are made as appropriate in order to protect
against the global effects of in-place modification.
Optionally set the compression level the same way as for \code{"fst"}.
\item \code{"fst_tbl"}: Same as \code{"fst"}, but the value is a \code{tibble}.
Optionally set the compression level the same way as for \code{"fst"}.
\item \code{"keras"}: superseded by \code{\link[=tar_format]{tar_format()}} and incompatible
with \code{error = "null"} (in \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}).
Uses \code{keras::save_model_hdf5()} and
\code{keras::load_model_hdf5()}. The value must be a Keras model.
Requires the \code{keras} package (not installed by default).
\item \code{"torch"}: superseded by \code{\link[=tar_format]{tar_format()}} and incompatible
with \code{error = "null"} (in \code{\link[=tar_target]{tar_target()}} or \code{\link[=tar_option_set]{tar_option_set()}}).
Uses \code{torch::torch_save()} and \code{torch::torch_load()}.
The value must be an object from the \code{torch} package
such as a tensor or neural network module.
Requires the \code{torch} package (not installed by default).
\item \code{"file"}: A dynamic file. To use this format,
the target needs to manually identify or save some data
and return a character vector of paths
to the data (must be a single file path if \code{repository}
is not \code{"local"}). (These paths must be existing files
and nonempty directories.)
Then, \code{targets} automatically checks those files and cues
the appropriate run/skip decisions if those files are out of date.
Those paths must point to files or directories,
and they must not contain characters \code{|} or \code{*}.
All the files and directories you return must actually exist,
or else \code{targets} will throw an error. (And if \code{storage} is \code{"worker"},
\code{targets} will first stall out trying to wait for the file
to arrive over a network file system.)
If the target does not create any files, the return value should be
\code{character(0)}.

If \code{repository} is not \code{"local"} and \code{format} is \code{"file"},
then the character vector returned by the target must be of length 1
and point to a single file. (Directories and vectors of multiple
file paths are not supported for dynamic files on the cloud.)
That output file is uploaded to the cloud and tracked for changes
where it exists in the cloud. The local file is deleted after
the target runs.
\item \code{"url"}: A dynamic input URL. For this storage format,
\code{repository} is implicitly \code{"local"},
URL format is like \code{format = "file"}
except the return value of the target is a URL that already exists
and serves as input data for downstream targets. Optionally
supply a custom \code{curl} handle through
\code{tar_resources()} and \code{tar_resources_url()}.
in \code{new_handle()}, \code{nobody = TRUE} is important because it
ensures \code{targets} just downloads the metadata instead of
the entire data file when it checks time stamps and hashes.
The data file at the URL needs to have an ETag or a Last-Modified
time stamp, or else the target will throw an error because
it cannot track the data. Also, use extreme caution when
trying to use \code{format = "url"} to track uploads. You must be absolutely
certain the ETag and Last-Modified time stamp are fully updated
and available by the time the target's command finishes running.
\code{targets} makes no attempt to wait for the web server.
\item A custom format can be supplied with \code{tar_format()}. For this choice,
it is the user's responsibility to provide methods for (un)serialization
and (un)marshaling the return value of the target.
\item The formats starting with \code{"aws_"} are deprecated as of 2022-03-13
(\code{targets} version > 0.10.0). For cloud storage integration, use the
\code{repository} argument instead.
}

Formats \code{"rds"}, \code{"file"}, and \code{"url"} are general-purpose formats
that belong in the \code{targets} package itself.
Going forward, any additional formats should be implemented with
\code{\link[=tar_format]{tar_format()}} in third-party packages like \code{tarchetypes}
and \code{geotargets} (for example: \code{tarchetypes::tar_format_nanoparquet()}).
Formats \code{"qs"}, \code{"fst"}, etc. are legacy formats from before the
existence of \code{\link[=tar_format]{tar_format()}}, and they will continue to remain in
\code{targets} without deprecation.
}

\examples{
tar_option_get("format") # default format before we set anything
tar_target(x, 1)$settings$format
tar_option_set(format = "fst_tbl") # new default format
tar_option_get("format")
tar_target(x, 1)$settings$format
tar_option_reset() # reset the format
tar_target(x, 1)$settings$format
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  tar_option_set(cue = tar_cue(mode = "always")) # All targets always run.
  list(tar_target(x, 1), tar_target(y, 2))
})
tar_make()
tar_make()
})
}
}
\seealso{
Other configuration: 
\code{\link{tar_config_get}()},
\code{\link{tar_config_projects}()},
\code{\link{tar_config_set}()},
\code{\link{tar_config_unset}()},
\code{\link{tar_config_yaml}()},
\code{\link{tar_envvars}()},
\code{\link{tar_option_get}()},
\code{\link{tar_option_reset}()}
}
\concept{configuration}
