% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_renv.R
\name{tar_renv}
\alias{tar_renv}
\title{Set up package dependencies for compatibility with \code{renv}}
\usage{
tar_renv(
  extras = c("bs4Dash", "clustermq", "future", "gt", "markdown", "pingr", "rstudioapi",
    "shiny", "shinybusy", "shinyWidgets", "visNetwork"),
  path = "_targets_packages.R",
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function),
  envir = parent.frame(),
  script = targets::tar_config_get("script")
)
}
\arguments{
\item{extras}{Character vector of additional packages to declare as
project dependencies.}

\item{path}{Character of length 1, path to the script file to
populate with \code{library()} calls.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}
}
\value{
Nothing, invisibly.
}
\description{
Write package dependencies to a script file
(by default, named \verb{_targets_packages.R} in the root project directory).
Each package is written to a separate line
as a standard \code{\link[=library]{library()}} call (e.g. \code{library(package)}) so
\code{renv} can identify them automatically.
}
\details{
This function gets called for its side-effect, which writes
package dependencies to a script for compatibility with \code{renv}.
The generated file should \strong{not} be edited by hand and will be
overwritten each time \code{tar_renv()} is called.

The behavior of \code{renv} is to create and manage a project-local \code{R} library
and keep a record of project dependencies in a file called \code{renv.lock}.
To identify dependencies, \code{renv} crawls through code to find packages
explicitly mentioned using \code{library()}, \code{require()}, or \code{::}.
However, \code{targets} manages packages in a way that hides dependencies
from \code{renv.} \code{tar_renv()} finds package dependencies that would be
otherwise hidden to \code{renv} because they are declared using the \code{targets}
API. Thus, calling \code{tar_renv} this is only necessary if using
\code{\link[=tar_option_set]{tar_option_set()}} or \code{\link[=tar_target]{tar_target()}} to use specialized storage
formats or manage packages.

With the script written by \code{tar_renv()}, \code{renv} is able to crawl the
file to identify package dependencies (with \code{renv::dependencies()}).
\code{tar_renv()} only serves to make your \code{targets} project compatible with
\code{renv}, it is still the users responsibility to call \code{renv::init()} and
\code{renv::snapshot()} directly to initialize and manage a
project-local \code{R} library. This allows your \code{targets} pipeline to have
its own self-contained \code{R} library separate from your standard \code{R}
library. See \url{https://rstudio.github.io/renv/index.html} for
more information.
}
\section{Performance}{

If you use \code{renv}, then overhead from project initialization
could slow down \code{\link[=tar_make]{tar_make()}} and friends.
If you experience slowness, please make sure your \code{renv} library
is on a fast file system.
(For example, slow network drives can severely reduce performance.)
In addition, you can disable the slowest \code{renv} initialization checks.
After confirming at
\url{https://rstudio.github.io/renv/reference/config.html}
that you can safely disable these checks,
you can write lines \code{RENV_CONFIG_RSPM_ENABLED=false},
\code{RENV_CONFIG_SANDBOX_ENABLED=false},
and \code{RENV_CONFIG_SYNCHRONIZED_CHECK=false}
in your user-level \code{.Renviron} file. If you disable the synchronization
check, remember to call \code{renv::status()} periodically
to check the health of your \code{renv} project library.
}

\examples{
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
  tar_script({
    tar_option_set(packages = c("tibble", "qs"))
    list()
  }, ask = FALSE)
  tar_renv()
  writeLines(readLines("_targets_packages.R"))
})
tar_option_reset()
}
\seealso{
\url{https://rstudio.github.io/renv/articles/renv.html}

Other scripts: 
\code{\link{tar_edit}()},
\code{\link{tar_github_actions}()},
\code{\link{tar_helper_raw}()},
\code{\link{tar_helper}()},
\code{\link{tar_script}()}
}
\concept{scripts}
