% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_backoff.R
\name{tar_backoff}
\alias{tar_backoff}
\title{Exponential backoff}
\usage{
tar_backoff(min = 0.001, max = 0.1, rate = 1.5)
}
\arguments{
\item{min}{Positive numeric of length 1,
minimum polling interval in seconds.
Must be at least \code{sqrt(.Machine$double.eps)}.}

\item{max}{Positive numeric of length 1,
maximum polling interval in seconds.
Must be at least \code{sqrt(.Machine$double.eps)}.}

\item{rate}{Positive numeric of length 1, greater than or equal to 1.
Multiplicative rate parameter that allows the exponential backoff
minimum polling interval to increase from \code{min} to \code{max}.
Actual polling intervals are sampled uniformly from the current
minimum to \code{max}.}
}
\description{
Configure exponential backoff while polling for tasks
during the pipeline.
}
\details{
This function is for advanced usage only. Most users
should not need to modify the default exponential backoff.
To configure exponential backoff for a pipeline,
supply the output of \code{tar_backoff()} to the \code{backoff} argument
of \code{\link[=tar_option_set]{tar_option_set()}} in the \verb{_targets.R} file. See the Backoff
section of the help file for details.
}
\section{Backoff}{

In high-performance computing it can be expensive to repeatedly poll the
priority queue if no targets are ready to process. The number of seconds
between polls is \code{runif(1, min, max(max, min * rate ^ index))},
where \code{index} is the number of consecutive polls so far that found
no targets ready to skip or run, and \code{min}, \code{max}, and \code{rate}
are arguments to \code{\link[=tar_backoff]{tar_backoff()}}.
(If no target is ready, \code{index} goes up by 1. If a target is ready,
\code{index} resets to 0. For more information on exponential,
backoff, visit \url{https://en.wikipedia.org/wiki/Exponential_backoff}).
Raising \code{min} or \code{max} is kinder to the CPU etc. but may incur delays
in some instances.
}

\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_option_set(backoff = tar_backoff(min = 0.001, max = 0.1, rate = 1.5))
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_path}()},
\code{\link{tar_seed}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
