% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_script.R
\name{tar_script}
\alias{tar_script}
\title{Write a target script file.}
\usage{
tar_script(
  code = NULL,
  library_targets = TRUE,
  ask = NULL,
  script = targets::tar_config_get("script")
)
}
\arguments{
\item{code}{R code to write to the target script file.
If \code{NULL}, an example target script file is written instead.}

\item{library_targets}{logical, whether to write a \code{library(targets)}
line at the top of the target script file automatically (recommended).
If \code{TRUE}, you do not need to explicitly put \code{library(targets)}
in \code{code}.}

\item{ask}{Logical, whether to ask before writing if the
target script file
already exists. If \code{NULL}, defaults to \code{Sys.getenv("TAR_ASK")}.
(Set to \code{"true"} or \code{"false"} with \code{Sys.setenv()}).
If \code{ask} and the \code{TAR_ASK} environment variable are both
indeterminate, defaults to \code{interactive()}.}

\item{script}{Character of length 1, where to write
the target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}.}
}
\value{
\code{NULL} (invisibly).
}
\description{
The \code{tar_script()} function is a convenient
way to create the required target script file (default: \verb{_targets.R})
in the current working directory.
It always overwrites the existing target script,
and it requires you to be in the working directory
where you intend to write the file, so be careful.
See the "Target script" section for details.
}
\section{Target script file}{

Every \code{targets} project requires a target script file.
The target script file is usually a file called \verb{_targets.R}
Functions \code{\link[=tar_make]{tar_make()}} and friends look for the target script
and run it to set up the pipeline just prior to the main task.
Every target script file should run the following
steps in the order below:
\enumerate{
\item Package: load the \code{targets} package. This step is automatically
inserted at the top of the target script file produced by
\code{tar_script()} if \code{library_targets} is \code{TRUE},
so you do not need to explicitly include it in \code{code}.
\item Globals: load custom functions and global objects into memory.
Usually, this section is a bunch of calls to \code{source()} that run
scripts defining user-defined functions. These functions support
the R commands of the targets.
\item Options: call \code{\link[=tar_option_set]{tar_option_set()}} to set defaults for targets-specific
settings such as the names of required packages. Even if you have no
specific options to set, it is still recommended to call
\code{\link[=tar_option_set]{tar_option_set()}} in order to register the proper environment.
\item Targets: define one or more target objects using \code{\link[=tar_target]{tar_target()}}.
\item Pipeline: call \code{\link[=list]{list()}} to bring the targets from (3)
together in a pipeline object. Every target script file must return
a pipeline object, which usually means ending with a call to
\code{\link[=list]{list()}}. In practice, (3) and (4) can be combined together
in the same function call.
}
}

\examples{
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script() # Writes an example target script file.
# Writes a user-defined target script:
tar_script({
  x <- tar_target(x, 1 + 1)
  tar_option_set()
  list(x)
}, ask = FALSE)
writeLines(readLines("_targets.R"))
})
}
\seealso{
Other scripts: 
\code{\link{tar_edit}()},
\code{\link{tar_github_actions}()},
\code{\link{tar_helper}()},
\code{\link{tar_helper_raw}()},
\code{\link{tar_renv}()}
}
\concept{scripts}
