% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tar_described_as.R
\name{tar_described_as}
\alias{tar_described_as}
\title{Select targets using their descriptions.}
\usage{
tar_described_as(
  described_as = NULL,
  tidyselect = TRUE,
  callr_function = callr::r,
  callr_arguments = targets::tar_callr_args_default(callr_function),
  envir = parent.frame(),
  script = targets::tar_config_get("script")
)
}
\arguments{
\item{described_as}{A \code{tidyselect} expression to select targets
based on their descriptions. For example,
\code{described_as = starts_with("survival model")} matches all
targets in the pipeline whose \code{description} arguments
of \code{\link[=tar_target]{tar_target()}} start with the text string \code{"survival model"}.}

\item{tidyselect}{If \code{TRUE}, return a call to \code{tidyselect::all_of()}
identifying the selected targets, which can then be supplied to any
\code{tidyselect}-compatible names\verb{argument of downstream functions like [tar_make()] and [tar_manifest()]. If}FALSE`, return a simple character vector of target names.}

\item{callr_function}{A function from \code{callr} to start a fresh clean R
process to do the work. Set to \code{NULL} to run in the current session
instead of an external process (but restart your R session just before
you do in order to clear debris out of the global environment).
\code{callr_function} needs to be \code{NULL} for interactive debugging,
e.g. \code{tar_option_set(debug = "your_target")}.
However, \code{callr_function} should not be \code{NULL} for serious
reproducible work.}

\item{callr_arguments}{A list of arguments to \code{callr_function}.}

\item{envir}{An environment, where to run the target R script
(default: \verb{_targets.R}) if \code{callr_function} is \code{NULL}.
Ignored if \code{callr_function} is anything other than \code{NULL}.
\code{callr_function} should only be \code{NULL} for debugging and
testing purposes, not for serious runs of a pipeline, etc.

The \code{envir} argument of \code{\link[=tar_make]{tar_make()}} and related
functions always overrides
the current value of \code{tar_option_get("envir")} in the current R session
just before running the target script file,
so whenever you need to set an alternative \code{envir}, you should always set
it with \code{tar_option_set()} from within the target script file.
In other words, if you call \code{tar_option_set(envir = envir1)} in an
interactive session and then
\code{tar_make(envir = envir2, callr_function = NULL)},
then \code{envir2} will be used.}

\item{script}{Character of length 1, path to the
target script file. Defaults to \code{tar_config_get("script")},
which in turn defaults to \verb{_targets.R}. When you set
this argument, the value of \code{tar_config_get("script")}
is temporarily changed for the current function call.
See \code{\link[=tar_script]{tar_script()}},
\code{\link[=tar_config_get]{tar_config_get()}}, and \code{\link[=tar_config_set]{tar_config_set()}} for details
about the target script file and how to set it
persistently for a project.}
}
\value{
If \code{tidyselect} is \code{TRUE}, then \code{\link[=tar_described_as]{tar_described_as()}} returns
a call to \code{tidyselect::all_of()} which can be supplied to the \code{names}
argument of functions like \code{\link[=tar_manifest]{tar_manifest()}} and \code{\link[=tar_make]{tar_make()}}.
This allows functions like \code{\link[=tar_manifest]{tar_manifest()}} and \code{\link[=tar_make]{tar_make()}}
to focus on only the targets with the matching descriptions.
If \code{tidyselect} is \code{FALSE}, then \code{\link[=tar_described_as]{tar_described_as()}} returns
a simple character vector of the names of all the targets in the
pipeline with matching descriptions.
}
\description{
Select a subset of targets in the \verb{_targets.R} file
based on their custom descriptions.
}
\details{
Targets with empty descriptions are ignored.
}
\examples{
if (identical(Sys.getenv("TAR_EXAMPLES"), "true")) { # for CRAN
tar_dir({ # tar_dir() runs code from a temp dir for CRAN.
tar_script({
  library(targets)
  library(tarchetypes)
  list(
    tar_target(b2, TRUE, description = "blue two"),
    tar_target(b3, TRUE, description = "blue three"),
    tar_target(g2, TRUE, description = "green two"),
    tar_target(g3, TRUE, description = "green three"),
    tar_target(g4, TRUE, description = "green three")
  )
}, ask = FALSE)
tar_described_as(starts_with("green"), tidyselect = FALSE)
tar_make(names = tar_described_as(starts_with("green")))
tar_progress() # Only `g2`, `g3`, and `g4` ran.
})
}
}
\seealso{
Other utilities: 
\code{\link{tar_active}()},
\code{\link{tar_backoff}()},
\code{\link{tar_call}()},
\code{\link{tar_cancel}()},
\code{\link{tar_definition}()},
\code{\link{tar_envir}()},
\code{\link{tar_format_get}()},
\code{\link{tar_group}()},
\code{\link{tar_name}()},
\code{\link{tar_path}()},
\code{\link{tar_path_script}()},
\code{\link{tar_path_script_support}()},
\code{\link{tar_path_store}()},
\code{\link{tar_path_target}()},
\code{\link{tar_source}()},
\code{\link{tar_store}()}
}
\concept{utilities}
