% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tatoo.R
\docType{package}
\name{tatoo}
\alias{tatoo}
\alias{tatoo-package}
\alias{tatoo-package}
\title{Table tools: tools for combining data frames and exporting them to xlsx}
\description{
Tatoo ("Table Tools") provides three straight-forward helper to combine
multiple \code{data.frames} to tables that are otherwise awkward to create in
base-r, and a way to add metadata (id, title, ...) to a table. In addition,
the Tatto_report class is provided as a convenient helper to write several
Tatoo tables to a workbook, one table per worksheet.
}
\details{
Tatoo tables and reports can directly be saved to .xlsx files, or convert to
\code{Workbook} objects with \code{as_workbook()} so that you can process them further
using the \code{openxlsx} package. While tatoo implements convenient print methods
so that you can preview the tables you created in the console, most of the
functionality provided by this package only makes real sense for .xlsx
export.
}
\section{Functions}{
 * \code{\link[=tag_table]{tag_table()}}: add captioning (title, footer, ...) to a
table * \code{\link[=comp_table]{comp_table()}}: like \code{\link[=cbind]{cbind()}} or \code{\link[=merge]{merge()}}, but retain
multi-column headings * \code{\link[=mash_table]{mash_table()}}: combine data.frames so that their
rows or columns alternate * \code{\link[=stack_table]{stack_table()}}: create a list of tables that
can be exported to xlsx, all tables on the same worksheet on top of each
others * \code{\link[=compile_report]{compile_report()}}: create a list of tables that can be exported
to xlsx, one table per worksheet (a Stacked_table also counts as one table)
\itemize{
\item \code{\link[=as_workbook]{as_workbook()}} / \code{\link[=save_xlsx]{save_xlsx()}}: export to excel
}
}

\author{
\strong{Maintainer}: Stefan Fleck \email{stefan.b.fleck@gmail.com}

}
