% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagged_table.R
\name{tag_table}
\alias{tag_table}
\alias{Tagged_table}
\alias{tagged_table}
\title{Tag tables}
\usage{
tag_table(dat, meta)
}
\arguments{
\item{dat}{A \code{Tatto_table} object or anything that can be coerced to a
\code{\link{data.table}} with \code{as.data.table()}}

\item{meta}{a \link{tt_meta} object. Metadata can also be set and modified
using setters (see \code{\link[=meta]{meta()}})}
}
\value{
a \code{Tagged_table}: a \code{Tatoo_table} with an additional \code{meta}
attribute
}
\description{
Add metadata/captioning (like \code{table_id}, \code{title}, \code{footer}) to a
\code{\link{Tatoo_table}} or \code{data.frame}. This metadata will be used by
\code{print} methods and export functions such as \code{\link{as_workbook}}
or \code{\link{save_xlsx}}.
}
\details{
For convenience, functions to get and set the basic metadata elements
such as \code{title} are also provided. Those can be used to either
modify an existing \code{Tagged_table}, or convert an object that is not yet
a \code{Tagged_table} to one.
}
\examples{

dat <- data.frame(
  name  = c("hans", "franz", "dolores"),
  grade = c(1, 3, 2)
)

table_metadata <- tt_meta(
  table_id = "Tab1",
  title = "Grades",
  longtitle = "grades of the final examination"
)

# Metadata can be assign in a formal way or via set functions
dat <- tag_table(dat,  meta = table_metadata)
meta(dat) <- table_metadata

# Table metadata is stored as an attribute, and cann be acces thus. It can
# also be modified via convenient set functions
attr(dat, 'meta')$title
meta(dat)$title
longtitle(dat) <- "Grades of the final examination"

# [1] "Grades"

print(dat)

# Tab1: Grades - Grades of the final examination
#
# name grade
# 1:    hans     1
# 2:   franz     3
# 3: dolores     2

}
\seealso{
Attribute setters: \link{meta<-}

Tagged Table Metadata: \link{tt_meta}

Other Tatoo tables: \code{\link{comp_table}},
  \code{\link{mash_table}}, \code{\link{stack_table}},
  \code{\link{tatoo_table}}
}
