% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/walk_regions.R
\name{walk_regions}
\alias{walk_regions}
\alias{map_regions}
\title{Apply a function to all named regions on an openxlsx Workbook}
\usage{
walk_regions(.wb, .pattern = ".*", .fun, ...)

map_regions(.wb, .pattern = ".*", .fun, ...)
}
\arguments{
\item{.wb}{an openxlsx \code{Workbook} Object}

\item{.pattern}{\code{character} scalar. A regex filter pattern for named region
names (passed on to \code{\link[=grep]{grep()}})}

\item{.fun}{A function with the formal arguments \code{wb}, \code{sheet} and either
\code{rows}, \code{cols}, or both. For example:
\code{\link[openxlsx:addStyle]{openxlsx::addStyle()}}, \code{\link[openxlsx:addFilter]{openxlsx::addFilter()}},
\code{\link[openxlsx:setRowHeights]{openxlsx::setRowHeights()}}, \code{\link[openxlsx:setColWidths]{openxlsx::setColWidths()}}}

\item{...}{passed on to \code{.fun}}
}
\value{
\code{walk_regions} returns \code{.wb}. \code{map_regions} returns a modified copy
of \code{.wb}
}
\description{
This applies a \code{.fun} to all named regions in a workbook names match
\code{.pattern}. This is especially useful since \code{\link[=as_workbook]{as_workbook()}} methods for
\code{Tatoo_tables} add named regions for certain parts of the Table. See also
\code{vignette("named_regions")} for how the names of named regions are
constructed by tatoo.

\code{map_regions()} is a wrapper for \code{walk_regions()} for people who prefer
standard R copy-on-modify semantics over openxlsx's pass-by-reference.
}
\examples{

x <- iris
title(iris) <- "Iris example table"
wb <- as_workbook(iris)

regions(wb)  # display regions


# Apply a style
# Keep in mind that openxlsx functions modify worksheets by reference.
# If you do not want this behaviour you can use map_regions instead.

style <- openxlsx::createStyle(textDecoration = "bold")
walk_regions(
  wb,
  .pattern = "colnames.*",
  .fun = openxlsx::addStyle,
  style = style
)

\dontrun{
  openxlsx::openXL(wb)
}



}
