\name{plotPerformance}
\alias{portfolioReturns}
\alias{portfolioPerformance}
\alias{plotPerformance}
\alias{compare.EqualWeighted}
\alias{compare.Market}
\title{ Calculate some portfolio statistics and compare with other portfolios or benchmarks }
\description{
  The group of compare.* functions plot the performance of additional benchmarks
  such as an equal weighted portfolio over the same time period or a benchmark
  market (e.g. DJIA or S&P500).
}
\usage{
portfolioReturns(h, weights)

portfolioPerformance(p, rf.rate = 0.01)

plotPerformance(h, weights, window = NULL, rf.rate = 0.01, new.plot = TRUE, y.min = -0.25, y.max = 0.25, bg = NULL, name = "", color = "red", colors = c(), legend.loc = 'bottomright', ...)

compare.EqualWeighted(h, window, color = "#342a31", ...)

compare.Market(market, obs, window, end = Sys.Date(), color = "#44bc43", ...)
}
\arguments{
  \item{h}{ Asset returns as used elsewhere in this package }
  \item{p}{ Portfolio returns (h \%*\% weights) }
  \item{weights}{ Portfolio weights over the given time period }
  \item{window}{ Size of window used in other calculations }
  \item{obs}{ Number of observations to retrieve }
  \item{end}{ End date of data to retrieve }
  \item{rf.rate}{ A risk free rate to use when calculating the sharpe ratio }
  \item{new.plot}{ Pass-through to new in plot }
  \item{y.min}{ Minimum y value for plot }
  \item{y.max}{ Maximum y value for plot }
  \item{bg}{ Background color currently unused }
  \item{name}{ The name of the series to use in the legend }
  \item{color}{ Color of the plot }
  \item{colors}{ Current colors (and names) of lines plotted on the chart }
  \item{legend.loc}{ Location of legend in chart }
  \item{market}{ A string or zoo/xts object representing the market to use }
  \item{\dots}{ Additional parameters to plot/lines }
}
\details{
  These functions are provided to assist in the analysis of the resultant
  portfolio weights generated by the package. The function plotPerformance
  plots the performance of a portfolio and calculates basic statistics. For
  more detailed analysis, use a specialized package such as 
  PerformanceAnalytics.

  The equal weighted portfolio is simply the same portfolio weight for each
  asset in the specified portfolio. For this to be meaningful, the same 
  portfolio and window are passed into the function as with the 
  \code{optimizePortfolio} call thus ensuring that the equal weighted portfolio
  and corresponding returns are constructed correctly.

  When comparing to the market portfolio, the number of observations need to be
  specified again so the market portfolio and corresponding returns are 
  constructed properly.
}
\value{
  A list of portfolio statistics.

  \item{returns}{The daily portfolio returns}
  \item{perf}{Cumulative return over time period}
  \item{stdev}{Standard deviation of portfolio over time period}
  \item{avg.return}{Average return of portfolio}
  \item{sharpe.ratio}{Sharpe ratio of portfolio}
}
\author{ Brian Lee Yung Rowe }
\examples{
# This is autorun outside of examples
tawny:::.init()

data(sp500.subset)
ys <- sp500.subset
ws <- optimizePortfolio(ys, 150, getCorFilter.RMT())
plotPerformance(ys, ws, 150)
compare.EqualWeighted(ys, 150)
compare.Market('^GSPC', 200, 150)
}
\keyword{ ts }
