% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/taxonomy--docs.R
\name{subtaxa}
\alias{subtaxa}
\title{Get subtaxa}
\arguments{
\item{obj}{The \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}} object containing taxon
information to be queried.}

\item{subset}{Taxon IDs, TRUE/FALSE vector, or taxon indexes to find subtaxa for.
Default: All taxa in \code{obj} will be used. Any variable name that appears in
\code{\link[=all_names]{all_names()}} can be used as if it was a vector on its own.}

\item{recursive}{(\code{logical} or \code{numeric}) If \code{FALSE}, only return the subtaxa
one rank below the target taxa. If \code{TRUE}, return all the subtaxa of every
subtaxa, etc. Positive numbers indicate the number of ranks below the
immediate subtaxa to return. \code{1} is equivalent to \code{FALSE}. Negative numbers
are equivalent to \code{TRUE}. Since the algorithm is optimized for traversing
all of large trees, \code{numeric} values greater than 0 for this option
actually take slightly longer to compute than either TRUE or FALSE.}

\item{simplify}{(\code{logical}) If \code{TRUE}, then combine all the results
into a single vector of unique values.}

\item{include_input}{(\code{logical}) If \code{TRUE}, the input taxa are
included in the output}

\item{value}{What data to return. This is usually the name of column in a
table in \code{obj$data}. Any result of \code{\link[=all_names]{all_names()}} can be used, but it
usually only makes sense to data that corresponds to taxa 1:1, such as
\code{\link[=taxon_ranks]{taxon_ranks()}}. By default, taxon indexes are returned.}
}
\value{
If \code{simplify = FALSE}, then a list of vectors are returned
corresponding to the \code{target} argument. If \code{simplify = TRUE},
then the unique values are returned in a single vector.
}
\description{
Return data for the subtaxa of each taxon in an \code{\link[=taxonomy]{taxonomy()}} or \code{\link[=taxmap]{taxmap()}}
object.
\preformatted{
obj$subtaxa(subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = NULL)
subtaxa(obj, subset = NULL, recursive = TRUE,
  simplify = FALSE, include_input = FALSE, value = NULL)}
}
\examples{
# return the indexes for subtaxa for each taxon
subtaxa(ex_taxmap)

# Only return data for some taxa using taxon indexes
subtaxa(ex_taxmap, subset = 1:3)

# Only return data for some taxa using taxon ids
subtaxa(ex_taxmap, subset = c("3", "4"))

# Only return data for some taxa using logical tests
subtaxa(ex_taxmap, subset = taxon_ranks == "genus")

# Only return subtaxa one level below
subtaxa(ex_taxmap, recursive = FALSE)

# Only return subtaxa some number of ranks below
subtaxa(ex_taxmap, recursive = 2)

# Return something besides taxon indexes
subtaxa(ex_taxmap, value = "taxon_names")
}
\seealso{
Other taxonomy indexing functions: \code{\link{branches}},
  \code{\link{internodes}}, \code{\link{leaves}},
  \code{\link{roots}}, \code{\link{stems}},
  \code{\link{supertaxa}}
}
