#' @name taxlist-package
#'
#' @docType package
#'
#' @title taxlist: Handling taxonomic lists.
#'
#' @details
#' The class [taxlist-class] is defined in this package using the
#' S4 language.
#' The main task of `taxlist` objects is to keep the taxonomic coherence of
#' information included in taxonomic lists and to implement functions (methods)
#' for a proper data handling.
#' Objects of class [taxlist-class] can be included in further
#' objects, for instance in biodiversity records as done in the package
#' \href{https://cran.r-project.org/package=vegtable}{vegtable}.
#'
#' For a more detailed description of this package, see Alvarez & Luebert
#' (2018).
#'
#' @description
#' The class [taxlist-class] is defined in this package using the
#' S4 language.
#' The main task of `taxlist` objects is to keep the taxonomic coherence of
#' information included in taxonomic lists and to implement functions (methods)
#' for a proper data handling.
#' Objects of class [taxlist-class] can be included in further
#' objects, for instance in biodiversity records as done in the package
#' \href{https://cran.r-project.org/package=vegtable}{vegtable}.
#'
#' @references
#' \bold{Alvarez M, Luebert F (2018).} The taxlist package: managing plant
#' taxonomic lists in R. \emph{Biodiversity Data Journal} 6: e23635.
#' \doi{10.3897/bdj.6.e23635}
#'
#' @author Miguel Alvarez \email{kamapu78@@gmail.com}
NULL
