% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_methods.R
\name{prepare_rank_dist}
\alias{prepare_rank_dist}
\title{Get all NCBI and GBIF taxonomic ranks}
\usage{
prepare_rank_dist(x, GBIF = FALSE, NCBI = FALSE)
}
\arguments{
\item{x}{A tibble created with \code{load_taxonomies()} or \code{load_population()} or \code{load_sample()}.}

\item{GBIF}{A boolean indicating whether GBIF taxonomic ranks are to be retrieved.}

\item{NCBI}{A boolean indicating whether NCBI taxonomic ranks are to be retrieved.}
}
\value{
A list of tibble(s) assigned to the S3 class \code{one_rank} or to the S3 class \code{all_ranks}.
}
\description{
\code{prepare_rank_dist()} returns taxonomic ranks aggregated by frequency for
data derived from the NCBI, the GBIF, or both.
}
\examples{
prepare_rank_dist(load_sample(), NCBI=TRUE, GBIF=TRUE)
prepare_rank_dist(load_sample(), NCBI=TRUE)
}
